package com.github.houbb.property.support.converter.impl.base;

import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.impl.AbstractValueConverter;

/**
 * @author binbin.hou
 * @since 0.0.5
 */
public class BooleanValueConverter extends AbstractValueConverter<Boolean> {

    @Override
    protected Boolean getFieldValue(String value, IFieldValueContext context) {
        return Boolean.valueOf(value);
    }

    @Override
    protected String getPropertyValue(Boolean value, IPropertyValueContext context) {
        return value.toString();
    }

}
