package com.github.houbb.property.support.converter.impl.base;

import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.impl.AbstractValueConverter;

/**
 * @author binbin.hou
 * @since 0.0.5
 */
public class CharacterValueConverter extends AbstractValueConverter<Character> {

    @Override
    protected Character getFieldValue(String value, IFieldValueContext context) {
        return value.charAt(0);
    }

    @Override
    protected String getPropertyValue(Character value, IPropertyValueContext context) {
        return value.toString();
    }

}
