package com.github.houbb.property.support.converter.impl.math;

import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.impl.AbstractNumberValueConverter;
import com.github.houbb.property.support.converter.impl.AbstractValueConverter;

import java.math.BigInteger;

/**
 * @author binbin.hou
 * @since 0.0.6
 */
public class BigIntegerValueConverter extends AbstractNumberValueConverter<BigInteger> {

    @Override
    protected BigInteger getNumberFieldValue(String value, IFieldValueContext context) {
        return BigInteger.valueOf(Long.parseLong(value));
    }

}
