package com.github.houbb.property.support.converter.impl.util;

import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.impl.AbstractValueConverter;

import java.util.Currency;

/**
 * 金额值转换类
 * @author binbin.hou
 * @since 0.0.6
 */
public class CurrencyValueConverter extends AbstractValueConverter<Currency> {

    @Override
    protected Currency getFieldValue(String value, IFieldValueContext context) {
        return Currency.getInstance(value);
    }

    @Override
    protected String getPropertyValue(Currency value, IPropertyValueContext context) {
        return value.toString();
    }

}
