package com.github.houbb.property.support.converter.impl.util;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.DateUtil;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.impl.AbstractValueConverter;

import java.text.DateFormat;
import java.util.Date;

/**
 * 日期数值转换类
 * @author binbin.hou
 * @since 0.0.6
 */
public class DateValueConverter extends AbstractValueConverter<Date> {

    @Override
    protected Date getFieldValue(String value, IFieldValueContext context) {
        String format = context.format();
        if(StringUtil.isNotEmpty(format)) {
            return DateUtil.getFormatDate(value, format);
        }

        return new Date(Long.parseLong(value));
    }

    @Override
    protected String getPropertyValue(Date value, IPropertyValueContext context) {
        String format = context.format();
        if(StringUtil.isNotEmpty(format)) {
            return DateUtil.getDateFormat(value, format);
        }

        return String.valueOf(value.getTime());
    }

}
