package com.github.houbb.property.support.properties;

import java.util.*;

/**
 *
 * 有序的屬性文件类
 *
 * JDK 自带的 properties 继承自 {@link Hashtable} 所以保存后的顺序是未知的。
 * 1. 此类用于解决乱序问题
 *
 * @author binbin.hou
 * @since 0.0.1
 */
public class OrderedProperties extends Properties {

    private final LinkedHashSet<Object> keys = new LinkedHashSet<>();

    @Override
    public Enumeration<Object> keys() {
        return Collections.enumeration(keys);
    }

    @Override
    public Object put(Object key, Object value) {
        keys.add(key);
        return super.put(key, value);
    }

    @Override
    public Set<Object> keySet() {
        return keys;
    }

    @Override
    public Set<String> stringPropertyNames() {
        Set<String> set = new LinkedHashSet<>();

        for (Object key : this.keys) {
            set.add((String) key);
        }

        return set;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrderedProperties that = (OrderedProperties) o;
        return Objects.equals(keys, that.keys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), keys);
    }
}
