/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.bs;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.property.api.IPropertyReader;
import com.github.houbb.property.core.IProperty;
import com.github.houbb.property.core.impl.SimpleProperty;
import com.github.houbb.property.exception.PropertyRuntimeException;
import com.github.houbb.property.support.bean.impl.BeanToMap;
import com.github.houbb.property.support.bean.impl.MapToBean;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class PropertyBs
implements IPropertyReader {
    private static final String DEFAULT_PATH = "$COM_GITHUB_HOUBB_PROPERTY_DEFAULT$";
    private static final Map<String, PropertyBs> INSTANCE_MAP = new ConcurrentHashMap<String, PropertyBs>();
    private final String path;
    private final IProperty property = new SimpleProperty();
    private String charset = "UTF-8";

    private PropertyBs(String path) {
        this.path = path;
    }

    public static PropertyBs getInstance(String propertyPath) {
        ArgUtil.notEmpty((String)propertyPath, (String)"propertyPath");
        PropertyBs instance = INSTANCE_MAP.get(propertyPath);
        if (ObjectUtil.isNotNull((Object)instance)) {
            return instance;
        }
        PropertyBs newInstance = new PropertyBs(propertyPath);
        if (!propertyPath.equals(DEFAULT_PATH)) {
            newInstance.load();
        }
        INSTANCE_MAP.put(propertyPath, newInstance);
        return newInstance;
    }

    public static PropertyBs getInstance() {
        return PropertyBs.getInstance(DEFAULT_PATH);
    }

    public PropertyBs charset(String charset) {
        ArgUtil.notEmpty((String)charset, (String)"charset");
        this.charset = charset;
        return this;
    }

    @Override
    public String get(String key) {
        ArgUtil.notEmpty((String)key, (String)"key");
        return this.property.getAttrString(key);
    }

    @Override
    public String getOrDefault(String key, String defaultValue) {
        ArgUtil.notEmpty((String)key, (String)"key");
        String value = this.get(key);
        if (ObjectUtil.isNotNull((Object)value)) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Boolean getBool(String key) {
        return StringUtil.toBool((String)this.get(key));
    }

    @Override
    public Byte getByte(String key) {
        return StringUtil.toByte((String)this.get(key));
    }

    @Override
    public Character getChar(String key) {
        return StringUtil.toChar((String)this.get(key));
    }

    @Override
    public Short getShort(String key) {
        return StringUtil.toShort((String)this.get(key));
    }

    @Override
    public Integer getInt(String key) {
        return StringUtil.toInt((String)this.get(key));
    }

    @Override
    public Long getLong(String key) {
        return StringUtil.toLong((String)this.get(key));
    }

    @Override
    public Float getFloat(String key) {
        return StringUtil.toFloat((String)this.get(key));
    }

    @Override
    public Double getDouble(String key) {
        return StringUtil.toDouble((String)this.get(key));
    }

    @Override
    public Date getDate(String key, String dateFormat) {
        return StringUtil.toDate((String)this.get(key), (String)dateFormat);
    }

    @Override
    public Date getDate(String key) {
        return StringUtil.toDate((String)this.get(key));
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return StringUtil.toBigInteger((String)this.get(key));
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return StringUtil.toBigDecimal((String)this.get(key));
    }

    public PropertyBs set(String key, String value) {
        ArgUtil.notEmpty((String)key, (String)"key");
        this.property.putAttr(key, value);
        return this;
    }

    public PropertyBs remove(String key) {
        ArgUtil.notEmpty((String)key, (String)"key");
        this.property.removeAttr(key);
        return this;
    }

    public synchronized PropertyBs flush() {
        return this.flush(this.path);
    }

    public synchronized PropertyBs flush(String path) {
        try {
            if (DEFAULT_PATH.equals(path)) {
                throw new PropertyRuntimeException("Forbidden write into the default path $COM_GITHUB_HOUBB_PROPERTY_DEFAULT$");
            }
            FileOutputStream outputStream = new FileOutputStream(path);
            this.property.flush(outputStream, this.charset);
            return this;
        }
        catch (FileNotFoundException e) {
            throw new PropertyRuntimeException(e);
        }
    }

    private synchronized PropertyBs load() {
        InputStream inputStream = StreamUtil.getInputStream((String)this.path);
        this.property.load(inputStream, "UTF-8");
        return this;
    }

    public PropertyBs set(Map<String, String> map) {
        if (MapUtil.isEmpty(map)) {
            return this;
        }
        this.property.putAttr(map);
        return this;
    }

    public PropertyBs set(Object bean) {
        Map<String, String> valueMap = ((BeanToMap)Instances.singleton(BeanToMap.class)).beanToMap(bean);
        return this.set(valueMap);
    }

    public Map<String, String> asMap() {
        return this.property.asMap();
    }

    public Properties asProperties() {
        return this.property.asProperties();
    }

    public Object asBean(Object bean) {
        ArgUtil.notNull((Object)bean, (String)"bean");
        Map<String, String> valueMap = this.asMap();
        ((MapToBean)Instances.singleton(MapToBean.class)).mapToBean(valueMap, bean);
        return this;
    }

    public <T> T asBean(Class<T> tClass) {
        ArgUtil.notNull(tClass, (String)"tClass");
        Object instance = ClassUtil.newInstance(tClass);
        return (T)this.asBean(instance);
    }
}

