/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.support.converter.factory;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.property.support.converter.IValueConverter;
import com.github.houbb.property.support.converter.impl.DefaultValueConverter;
import java.util.HashMap;
import java.util.Map;

public final class ValueConverterFactory {
    private static final Map<Class<? extends IValueConverter>, IValueConverter> CONVERTER_MAP;

    private ValueConverterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void register(Class<? extends IValueConverter> converterClass, IValueConverter valueConverter) {
        ArgUtil.notNull(converterClass, (String)"converterClass");
        ArgUtil.notNull((Object)valueConverter, (String)"valueConverter");
        Map<Class<? extends IValueConverter>, IValueConverter> map = CONVERTER_MAP;
        synchronized (map) {
            CONVERTER_MAP.put(converterClass, valueConverter);
        }
    }

    public static IValueConverter getConverter(Class<? extends IValueConverter> clazz) {
        IValueConverter valueConverter = CONVERTER_MAP.get(clazz);
        if (ObjectUtil.isNotNull((Object)valueConverter)) {
            return valueConverter;
        }
        valueConverter = (IValueConverter)ClassUtil.newInstance(clazz);
        if (clazz.isAnnotationPresent(ThreadSafe.class)) {
            ValueConverterFactory.register(clazz, valueConverter);
        }
        return valueConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<Class<? extends IValueConverter>, IValueConverter> map = CONVERTER_MAP = new HashMap<Class<? extends IValueConverter>, IValueConverter>();
        synchronized (map) {
            CONVERTER_MAP.put(DefaultValueConverter.class, new DefaultValueConverter());
        }
    }
}

