/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.bs;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.segment.api.ISegment;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.api.ISegmentResult;
import com.github.houbb.segment.support.data.ISegmentData;
import com.github.houbb.segment.support.data.impl.SegmentDatas;
import com.github.houbb.segment.support.format.ISegmentFormat;
import com.github.houbb.segment.support.format.impl.SegmentFormats;
import com.github.houbb.segment.support.segment.impl.SegmentContext;
import com.github.houbb.segment.support.segment.impl.Segments;
import com.github.houbb.segment.support.segment.mode.ISegmentMode;
import com.github.houbb.segment.support.segment.mode.impl.SegmentModes;
import com.github.houbb.segment.support.segment.result.ISegmentResultHandler;
import com.github.houbb.segment.support.segment.result.impl.SegmentResultHandlers;
import com.github.houbb.segment.support.tagging.pos.data.ISegmentPosData;
import com.github.houbb.segment.support.tagging.pos.data.impl.SegmentPosDatas;
import com.github.houbb.segment.support.tagging.pos.tag.ISegmentPosTagging;
import com.github.houbb.segment.support.tagging.pos.tag.impl.SegmentPosTaggings;
import java.util.List;

public final class SegmentBs {
    private ISegment segment = Segments.defaults();
    private ISegmentData data = SegmentDatas.mixed();
    private ISegmentMode mode = SegmentModes.search();
    private ISegmentFormat format = SegmentFormats.defaults();
    private ISegmentPosTagging posTagging = SegmentPosTaggings.none();
    private ISegmentPosData posData = SegmentPosDatas.mixed();

    private SegmentBs() {
    }

    public static SegmentBs newInstance() {
        return new SegmentBs();
    }

    public SegmentBs segmentData(ISegmentData segmentData) {
        ArgUtil.notNull((Object)segmentData, (String)"segmentData");
        this.data = segmentData;
        return this;
    }

    public SegmentBs segmentMode(ISegmentMode segmentMode) {
        ArgUtil.notNull((Object)segmentMode, (String)"segmentMode");
        this.mode = segmentMode;
        return this;
    }

    public SegmentBs segmentFormat(ISegmentFormat segmentFormat) {
        ArgUtil.notNull((Object)segmentFormat, (String)"segmentFormat");
        this.format = segmentFormat;
        return this;
    }

    public SegmentBs posTagging(ISegmentPosTagging posTagging) {
        this.posTagging = posTagging;
        return this;
    }

    public SegmentBs posData(ISegmentPosData posData) {
        this.posData = posData;
        return this;
    }

    public List<ISegmentResult> segment(String string) {
        return this.segment(string, SegmentResultHandlers.common());
    }

    public <R> R segment(String string, ISegmentResultHandler<R> handler) {
        ISegmentContext context = this.buildContext();
        List<ISegmentResult> segmentResults = this.segment.segment(string, context);
        return handler.handler(segmentResults);
    }

    private ISegmentContext buildContext() {
        return SegmentContext.newInstance().data(this.data).mode(this.mode).format(this.format).posTagging(this.posTagging).posData(this.posData);
    }
}

