/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.data.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.segment.model.SegmentWordEntry;
import com.github.houbb.segment.support.data.ISegmentData;
import com.github.houbb.segment.support.normalization.INormalization;
import com.github.houbb.segment.support.normalization.NormalizationResult;
import com.github.houbb.segment.support.normalization.impl.LogNormalization;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public abstract class AbstractSegmentData
implements ISegmentData {
    private static volatile NormalizationResult normalizationResult;

    protected abstract List<SegmentWordEntry> getStaticVolatileWordEntryList();

    protected abstract List<String> readDictLines();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SegmentWordEntry> getWordEntryList() {
        List<SegmentWordEntry> wordEntries = this.getStaticVolatileWordEntryList();
        if (CollectionUtil.isNotEmpty(wordEntries)) {
            return wordEntries;
        }
        Class<AbstractSegmentData> clazz = AbstractSegmentData.class;
        synchronized (AbstractSegmentData.class) {
            if (CollectionUtil.isEmpty(wordEntries)) {
                this.initWordEntryList(wordEntries);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return wordEntries;
        }
    }

    @Override
    public Set<String> getWordSet() {
        return this.getFreqMap().keySet();
    }

    @Override
    public Double getFreq(String word) {
        Map<String, Double> freqMap = this.getFreqMap();
        Double freq = freqMap.get(word);
        if (ObjectUtil.isNull((Object)freq)) {
            freq = normalizationResult.minFreq();
        }
        return freq;
    }

    private Map<String, Double> getFreqMap() {
        NormalizationResult normalizationResult = this.normalization();
        return normalizationResult.freqMap();
    }

    @Override
    public double getMinFreq() {
        NormalizationResult normalizationResult = this.normalization();
        return normalizationResult.minFreq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NormalizationResult normalization() {
        if (ObjectUtil.isNotNull((Object)normalizationResult)) {
            return normalizationResult;
        }
        Class<NormalizationResult> clazz = NormalizationResult.class;
        synchronized (NormalizationResult.class) {
            if (ObjectUtil.isNull((Object)normalizationResult)) {
                this.initNormalizationResult();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return normalizationResult;
        }
    }

    private void initNormalizationResult() {
        long startTime = System.currentTimeMillis();
        List<SegmentWordEntry> wordEntries = this.getWordEntryList();
        INormalization normalization = (INormalization)Instances.singleton(LogNormalization.class);
        normalizationResult = normalization.normalization(wordEntries);
        wordEntries.clear();
        long costTime = System.currentTimeMillis() - startTime;
        System.out.println("Normalization init finished, cost time : " + costTime + " ms!");
    }

    @Override
    public boolean contains(String word) {
        NormalizationResult normalizationResult = this.normalization();
        return normalizationResult.freqMap().containsKey(word);
    }

    private void initWordEntryList(List<SegmentWordEntry> segmentWordEntryList) {
        long startTime = System.currentTimeMillis();
        List<String> allLines = this.readDictLines();
        for (String line : allLines) {
            if (StringUtil.isEmptyTrim((String)line)) continue;
            List splitList = StringUtil.splitToList((String)line, (String)" ");
            String word = (String)splitList.get(0);
            long count = 3L;
            String type = "un";
            if (splitList.size() >= 2) {
                count = Long.parseLong((String)splitList.get(1));
            }
            if (splitList.size() >= 3) {
                type = (String)splitList.get(2);
            }
            SegmentWordEntry segmentWordEntry = SegmentWordEntry.newInstance().word(word).count(count).type(type);
            segmentWordEntryList.add(segmentWordEntry);
        }
        long costTime = System.currentTimeMillis() - startTime;
        System.out.println("[Segment] dict init word-list finish, cost time : " + costTime + " ms!");
    }
}

