/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.format.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.support.format.ISegmentFormat;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class ChineseTsSegmentFormat
implements ISegmentFormat {
    private static final Map<Character, Character> TS_CHAR_MAP = Guavas.newHashMap();

    @Override
    public char format(char ch, ISegmentContext context) {
        Character simple = TS_CHAR_MAP.get(Character.valueOf(ch));
        if (ObjectUtil.isNull((Object)simple)) {
            return ch;
        }
        return simple.charValue();
    }

    static {
        long startTime = System.currentTimeMillis();
        List lines = StreamUtil.readAllLines((String)"/segment_chinese_ts_char.txt");
        for (String line : lines) {
            String[] entries = line.split(" ");
            char tChar = entries[0].charAt(0);
            char sChar = entries[1].charAt(0);
            TS_CHAR_MAP.put(Character.valueOf(tChar), Character.valueOf(sChar));
        }
        long costTime = System.currentTimeMillis() - startTime;
        System.out.println("[Segment Format] chinese traditional-simple load finished, cost " + costTime + " ms");
    }
}

