/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.format.impl;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.support.pipeline.Pipeline;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.segment.support.format.ISegmentFormat;
import com.github.houbb.segment.support.format.impl.AbstractSegmentFormatInit;
import com.github.houbb.segment.support.format.impl.ChineseTsSegmentFormat;
import com.github.houbb.segment.support.format.impl.HalfWidthSegmentFormat;
import com.github.houbb.segment.support.format.impl.LowerCaseSegmentFormat;
import com.github.houbb.segment.support.format.impl.NoneSegmentFormat;

public final class SegmentFormats {
    private SegmentFormats() {
    }

    public static ISegmentFormat defaults() {
        return SegmentFormats.chains(SegmentFormats.halfWidth(), SegmentFormats.lowerCase());
    }

    public static ISegmentFormat halfWidth() {
        return (ISegmentFormat)Instances.singleton(HalfWidthSegmentFormat.class);
    }

    public static ISegmentFormat lowerCase() {
        return (ISegmentFormat)Instances.singleton(LowerCaseSegmentFormat.class);
    }

    public static ISegmentFormat chineseSimple() {
        return (ISegmentFormat)Instances.singleton(ChineseTsSegmentFormat.class);
    }

    public static ISegmentFormat none() {
        return (ISegmentFormat)Instances.singleton(NoneSegmentFormat.class);
    }

    public static ISegmentFormat chains(final ISegmentFormat ... formats) {
        if (ArrayUtil.isEmpty((Object[])formats)) {
            return SegmentFormats.none();
        }
        return new AbstractSegmentFormatInit(){

            @Override
            protected void init(Pipeline<ISegmentFormat> pipeline) {
                for (ISegmentFormat format : formats) {
                    pipeline.addLast((Object)format);
                }
            }
        };
    }
}

