/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.normalization.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.segment.model.SegmentWordEntry;
import com.github.houbb.segment.support.normalization.INormalization;
import com.github.houbb.segment.support.normalization.NormalizationResult;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class LogNormalization
implements INormalization {
    @Override
    public NormalizationResult normalization(List<SegmentWordEntry> wordEntries) {
        NormalizationResult result = new NormalizationResult();
        if (CollectionUtil.isEmpty(wordEntries)) {
            return result;
        }
        long minCount = Long.MAX_VALUE;
        long maxCount = Long.MIN_VALUE;
        double minFreq = Double.MAX_VALUE;
        double maxFreq = Double.MIN_VALUE;
        for (SegmentWordEntry segmentWordEntry : wordEntries) {
            long count = segmentWordEntry.count();
            if (minCount > count) {
                minCount = count;
            }
            if (maxCount >= count) continue;
            maxCount = count;
        }
        Map freqMap = Guavas.newHashMap((int)wordEntries.size());
        for (SegmentWordEntry segmentWordEntry : wordEntries) {
            double freq = Math.log((double)segmentWordEntry.count() * 1.0) / Math.log((double)maxCount * 1.0);
            if (minFreq > freq) {
                minFreq = freq;
            }
            if (maxFreq < freq) {
                maxFreq = freq;
            }
            freqMap.put(segmentWordEntry.word(), freq);
        }
        return result.minCount(minCount).maxCount(maxCount).minFreq(minFreq).maxFreq(maxFreq).freqMap(freqMap);
    }
}

