/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.segment.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.segment.api.ISegment;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.api.ISegmentResult;
import com.github.houbb.segment.support.segment.mode.ISegmentMode;
import com.github.houbb.segment.support.segment.mode.SegmentModeContext;
import com.github.houbb.segment.support.segment.mode.impl.SegmentModes;
import com.github.houbb.segment.util.CharUtils;
import java.util.List;

@ThreadSafe
public class PreciseSegment
implements ISegment {
    @Override
    public List<ISegmentResult> segment(String string, ISegmentContext context) {
        List segmentList = Guavas.newArrayList();
        int length = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (CharUtils.isConsequent(c)) {
                stringBuilder.append(c);
                continue;
            }
            int consequentLen = stringBuilder.length();
            if (consequentLen > 0) {
                int startIndex = i - consequentLen;
                segmentList.addAll(this.getSegmentResultList(stringBuilder, startIndex, context));
            }
            segmentList.addAll(this.singleCharSegment(string, i));
        }
        int consequentLen = stringBuilder.length();
        if (consequentLen > 0) {
            int startIndex = length - consequentLen;
            segmentList.addAll(this.getSegmentResultList(stringBuilder, startIndex, context));
        }
        return segmentList;
    }

    private List<ISegmentResult> getSegmentResultList(StringBuilder stringBuilder, int startIndex, ISegmentContext segmentContext) {
        String text = stringBuilder.toString();
        ISegmentMode segmentMode = segmentContext.mode();
        SegmentModeContext modeContext = SegmentModeContext.newInstance().string(text).startIndex(startIndex).segmentContext(segmentContext);
        stringBuilder.setLength(0);
        return segmentMode.select(modeContext);
    }

    private List<ISegmentResult> singleCharSegment(String string, int startIndex) {
        SegmentModeContext currentCharContext = SegmentModeContext.newInstance().string(string).startIndex(startIndex);
        return SegmentModes.single().select(currentCharContext);
    }
}

