/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.segment.mode.impl.precise;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.tuple.impl.Pair;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.api.ISegmentResult;
import com.github.houbb.segment.support.data.ISegmentData;
import com.github.houbb.segment.support.segment.impl.SegmentResult;
import com.github.houbb.segment.support.segment.mode.SegmentModeContext;
import com.github.houbb.segment.support.segment.mode.impl.precise.AbstractPreciseSegmentMode;
import com.github.houbb.segment.support.segment.strategy.ISegmentStrategy;
import com.github.houbb.segment.support.segment.strategy.impl.SegmentStrategies;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class DictSegmentMode
extends AbstractPreciseSegmentMode {
    @Override
    public List<ISegmentResult> select(SegmentModeContext segmentModeContext) {
        ISegmentContext context = segmentModeContext.segmentContext();
        String text = segmentModeContext.string();
        int startIndex = segmentModeContext.startIndex();
        Map<Integer, Pair<Integer, Double>> routeMap = this.buildRouteMap(text, context);
        List resultList = Guavas.newArrayList();
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            int routeIndex = this.getRouteIndex(routeMap, i);
            int wordLength = routeIndex - i;
            String word = text.substring(i, routeIndex);
            if (wordLength == 1) {
                stringBuffer.append(word);
            } else {
                int actualBufferIndex = startIndex + i;
                this.bufferToResultList(actualBufferIndex, stringBuffer, resultList, context);
                int actualStartIndex = startIndex + i;
                ISegmentResult result = this.buildSegmentResult(word, actualStartIndex);
                resultList.add(result);
            }
            i = routeIndex - 1;
        }
        if (stringBuffer.length() > 0) {
            int actualIndex = startIndex + text.length();
            this.bufferToResultList(actualIndex, stringBuffer, resultList, context);
        }
        return resultList;
    }

    protected Map<Integer, Pair<Integer, Double>> buildRouteMap(String text, ISegmentContext context) {
        Map<Integer, List<ISegmentResult>> segmentMap = this.getSegmentMap(text, context);
        return this.calcRouteMap(segmentMap, context);
    }

    private void bufferToResultList(int startIndex, StringBuilder stringBuffer, List<ISegmentResult> resultList, ISegmentContext segmentContext) {
        int bufferLength = stringBuffer.length();
        if (bufferLength <= 0) {
            return;
        }
        String bufferWord = stringBuffer.toString();
        int actualStartIndex = startIndex - bufferLength;
        if (bufferWord.length() == 1) {
            resultList.add(this.buildSegmentResult(bufferWord, actualStartIndex));
        } else {
            boolean dictContains = this.dictContainsWord(bufferWord, segmentContext);
            if (dictContains) {
                resultList.add(this.buildSegmentResult(bufferWord, actualStartIndex));
            } else {
                List<ISegmentResult> hmmSegmentResults = this.buildChineseSegments(bufferWord, actualStartIndex, segmentContext);
                resultList.addAll(hmmSegmentResults);
            }
        }
        stringBuffer.setLength(0);
    }

    protected boolean dictContainsWord(String bufferWord, ISegmentContext segmentContext) {
        ISegmentData segmentData = segmentContext.data();
        return segmentData.contains(bufferWord);
    }

    protected List<ISegmentResult> buildChineseSegments(String bufferWord, int actualStartIndex, ISegmentContext segmentContext) {
        ISegmentStrategy segmentStrategy = SegmentStrategies.simple();
        return segmentStrategy.segment(bufferWord, actualStartIndex, segmentContext);
    }

    protected ISegmentResult buildSegmentResult(String word, int startIndex) {
        return SegmentResult.newInstance().word(word).startIndex(startIndex).endIndex(startIndex + word.length());
    }

    private Map<Integer, List<ISegmentResult>> getSegmentMap(String text, ISegmentContext context) {
        int length = text.length();
        Map segmentMap = Guavas.newLinkedHashMap((int)length);
        ISegmentStrategy segmentStrategy = SegmentStrategies.tireTree();
        for (int i = 0; i < length; ++i) {
            List<ISegmentResult> segmentResults = segmentStrategy.segment(text, i, context);
            segmentMap.put(i, segmentResults);
        }
        return segmentMap;
    }

    private Map<Integer, Pair<Integer, Double>> calcRouteMap(Map<Integer, List<ISegmentResult>> segmentMap, ISegmentContext context) {
        ISegmentData segmentData = context.data();
        double minFreq = segmentData.getMinFreq();
        Map routeMap = Guavas.newLinkedHashMap();
        routeMap.put(-1, Pair.of((Object)0, (Object)0.0));
        for (Integer index : segmentMap.keySet()) {
            List<ISegmentResult> segmentResults = segmentMap.get(index);
            Pair candidate = null;
            for (ISegmentResult result : segmentResults) {
                int endIndex = result.endIndex();
                double routeFreq = this.getRouteFreq(routeMap, index - 1, minFreq);
                double freq = segmentData.getFreq(result.word()) + routeFreq;
                candidate = (Pair)routeMap.get(index);
                if (ObjectUtil.isNull((Object)candidate)) {
                    candidate = Pair.of((Object)endIndex, (Object)freq);
                    continue;
                }
                if (!(freq > (Double)candidate.getValueTwo())) continue;
                candidate = Pair.of((Object)endIndex, (Object)freq);
            }
            routeMap.put(index, candidate);
        }
        return routeMap;
    }

    private Double getRouteFreq(Map<Integer, Pair<Integer, Double>> routeMap, int index, double minFreq) {
        Pair<Integer, Double> pair = routeMap.get(index);
        if (ObjectUtil.isNotNull(pair)) {
            return (Double)pair.getValueTwo();
        }
        return minFreq;
    }

    private int getRouteIndex(Map<Integer, Pair<Integer, Double>> routeMap, int index) {
        Pair<Integer, Double> pair = routeMap.get(index);
        if (ObjectUtil.isNotNull(pair)) {
            return (Integer)pair.getValueOne();
        }
        return index + 1;
    }
}

