/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.segment.strategy.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.api.ISegmentResult;
import com.github.houbb.segment.support.format.ISegmentFormat;
import com.github.houbb.segment.support.segment.impl.SegmentResult;
import com.github.houbb.segment.support.segment.strategy.ISegmentStrategy;
import com.github.houbb.segment.util.CharUtils;
import java.util.List;

@ThreadSafe
public class SimpleSegmentStrategy
implements ISegmentStrategy {
    @Override
    public List<ISegmentResult> segment(String string, int startIndex, ISegmentContext context) {
        List wordList = Guavas.newArrayList();
        ISegmentFormat segmentFormat = context.format();
        StringBuilder chineseBuffer = new StringBuilder();
        StringBuilder otherBuffer = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (CharUtil.isChinese((char)c)) {
                chineseBuffer.append(c);
                this.processOtherChars(otherBuffer, wordList);
                continue;
            }
            otherBuffer.append(c);
            this.processChineseChars(chineseBuffer, wordList, context);
        }
        this.processChineseChars(chineseBuffer, wordList, context);
        this.processOtherChars(otherBuffer, wordList);
        List resultList = Guavas.newArrayList((int)wordList.size());
        int actualStartIndex = startIndex;
        for (String word : wordList) {
            SegmentResult segmentResult = SegmentResult.newInstance().word(word).startIndex(actualStartIndex).endIndex(actualStartIndex + word.length());
            actualStartIndex += word.length();
            resultList.add(segmentResult);
        }
        return resultList;
    }

    private void processChineseChars(StringBuilder buffer, List<String> wordList, ISegmentContext context) {
        int length = buffer.length();
        if (length <= 0) {
            return;
        }
        String text = buffer.toString();
        List<String> segments = this.getChineseSegments(text, context);
        wordList.addAll(segments);
        buffer.setLength(0);
    }

    protected List<String> getChineseSegments(String text, ISegmentContext context) {
        return StringUtil.toCharStringList((String)text);
    }

    private void processOtherChars(StringBuilder buffer, List<String> wordList) {
        int length = buffer.length();
        if (length <= 0) {
            return;
        }
        if (1 == length) {
            wordList.add(buffer.toString());
        } else {
            StringBuilder wordBuffer = new StringBuilder();
            for (int i = 0; i < buffer.length(); ++i) {
                char c = buffer.charAt(i);
                if (CharUtil.isDigitOrLetter((char)c) || CharUtils.isLetterOrConnector(c)) {
                    wordBuffer.append(c);
                    continue;
                }
                if (wordBuffer.length() > 0) {
                    wordList.add(wordBuffer.toString());
                    wordBuffer.setLength(0);
                }
                wordList.add(String.valueOf(c));
            }
            if (wordBuffer.length() > 0) {
                wordList.add(wordBuffer.toString());
                wordBuffer.setLength(0);
            }
        }
        buffer.setLength(0);
    }
}

