/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.segment.strategy.impl.hmm;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.support.format.ISegmentFormat;
import com.github.houbb.segment.support.segment.strategy.impl.SimpleSegmentStrategy;
import com.github.houbb.segment.support.segment.strategy.impl.hmm.Viterbi;
import java.util.List;

@ThreadSafe
public class HmmSegmentStrategy
extends SimpleSegmentStrategy {
    @Override
    protected List<String> getChineseSegments(String text, ISegmentContext context) {
        String formatText = this.formatText(text, context);
        return Viterbi.segment(text, formatText);
    }

    private String formatText(String text, ISegmentContext context) {
        if (StringUtil.isEmpty((String)text) || text.length() == 1) {
            return text;
        }
        StringBuilder stringBuilder = new StringBuilder(text.length());
        ISegmentFormat segmentFormat = context.format();
        for (char ch : text.toCharArray()) {
            char formatChar = segmentFormat.format(ch, context);
            stringBuilder.append(formatChar);
        }
        return stringBuilder.toString();
    }
}

