/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.segment.strategy.impl.hmm;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.segment.constant.enums.HmmStateEnum;
import java.util.List;
import java.util.Map;

public final class Viterbi {
    private static final double MIN_FLOAT = -3.14E100;
    private static final int[] STATE_INDEX = new int[]{0, 1, 2, 3};
    private static final double[] START_PROB = new double[]{-0.26268660809250016, -3.14E100, -3.14E100, -1.4652633398537678};
    private static final double[][] TRANS_PROB = new double[][]{{-3.14E100, -0.916290731874155, -0.51082562376599, -3.14E100}, {-3.14E100, -1.2603623820268226, -0.33344856811948514, -3.14E100}, {-3.14E100, 0.5897149736854513, -3.14E100, -0.8085250474669937}, {-0.7211965654669841, -3.14E100, -3.14E100, -0.6658631448798212}};
    private static final int[][] PREV_STATUS = new int[][]{{2, 3}, {1, 0}, {0, 1}, {3, 2}};
    private static volatile Map<Integer, Map<Character, Double>> emitPropMap;

    private Viterbi() {
    }

    public static List<String> segment(String text, String formatText) {
        List segmentList = Guavas.newArrayList();
        if (text.length() == 1) {
            segmentList.add(text);
            return segmentList;
        }
        char[] observerChars = formatText.toCharArray();
        int[] stateIndexArray = Viterbi.compute(observerChars, STATE_INDEX, START_PROB, TRANS_PROB);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            int stateIndex = stateIndexArray[i];
            stringBuilder.append(text.charAt(i));
            if (HmmStateEnum.SINGLE.index() != stateIndex && HmmStateEnum.END.index() != stateIndex) continue;
            String word = stringBuilder.toString();
            segmentList.add(word);
            stringBuilder.setLength(0);
        }
        if (stringBuilder.length() > 0) {
            String word = stringBuilder.toString();
            segmentList.add(word);
            stringBuilder.setLength(0);
        }
        return segmentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, Map<Character, Double>> getEmitPropMap() {
        if (ObjectUtil.isNotNull(emitPropMap)) {
            return emitPropMap;
        }
        Class<Viterbi> clazz = Viterbi.class;
        synchronized (Viterbi.class) {
            if (ObjectUtil.isNull(emitPropMap)) {
                emitPropMap = Guavas.newHashMap((int)4);
                emitPropMap.put(0, Guavas.newHashMap());
                emitPropMap.put(1, Guavas.newHashMap());
                emitPropMap.put(2, Guavas.newHashMap());
                emitPropMap.put(3, Guavas.newHashMap());
                List lines = StreamUtil.readAllLines((String)"/segment_emit_prob.txt");
                for (String line : lines) {
                    String[] entries = line.split(" ");
                    Integer index = Integer.valueOf(entries[0]);
                    Character character = Character.valueOf(entries[1].charAt(0));
                    Double prob = Double.valueOf(entries[2]);
                    emitPropMap.get(index).put(character, prob);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return emitPropMap;
        }
    }

    private static int[] compute(char[] observerChars, int[] states, double[] startProb, double[][] transProb) {
        double[][] V = new double[observerChars.length][states.length];
        int[][] path = new int[states.length][observerChars.length];
        for (int y : states) {
            double emitProb = Viterbi.getEmitProb(y, observerChars[0]);
            V[0][y] = startProb[y] + emitProb;
            path[y][0] = y;
        }
        for (int t = 1; t < observerChars.length; ++t) {
            int[][] newPath = new int[states.length][observerChars.length];
            for (int y : states) {
                int[] prevStates;
                double prob = -3.14E100;
                for (int y0 : prevStates = PREV_STATUS[y]) {
                    double emitProb = Viterbi.getEmitProb(y, observerChars[t]);
                    double nprob = V[t - 1][y0] + transProb[y0][y] + emitProb;
                    if (!(nprob > prob)) continue;
                    prob = nprob;
                    int state = y0;
                    V[t][y] = prob;
                    System.arraycopy(path[state], 0, newPath[y], 0, t);
                    newPath[y][t] = y;
                }
            }
            path = newPath;
        }
        double prob = -3.14E100;
        int state = 0;
        for (int y : states) {
            if (!(V[observerChars.length - 1][y] > prob)) continue;
            prob = V[observerChars.length - 1][y];
            state = y;
        }
        return path[state];
    }

    private static double getEmitProb(int stateIndex, char ch) {
        emitPropMap = Viterbi.getEmitPropMap();
        Map<Character, Double> probMap = emitPropMap.get(stateIndex);
        Double prob = probMap.get(Character.valueOf(ch));
        if (ObjectUtil.isNotNull((Object)prob)) {
            return prob;
        }
        return -3.14E100;
    }
}

