/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.tagging.pos.data.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.segment.model.SegmentPos;
import com.github.houbb.segment.support.tagging.pos.data.ISegmentPosData;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@ThreadSafe
public abstract class AbstractSegmentPosData
implements ISegmentPosData {
    protected abstract Map<String, List<SegmentPos>> getStaticVolatilePosMap();

    protected abstract List<String> readDictLines();

    @Override
    public List<SegmentPos> posList(String word) {
        if (StringUtil.isEmptyTrim((String)word)) {
            return Collections.emptyList();
        }
        Map<String, List<SegmentPos>> posMap = this.getPosMap();
        return posMap.get(word);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<SegmentPos>> getPosMap() {
        Map<String, List<SegmentPos>> map = this.getStaticVolatilePosMap();
        if (MapUtil.isNotEmpty(map)) {
            return map;
        }
        long startMills = System.currentTimeMillis();
        Class<AbstractSegmentPosData> clazz = AbstractSegmentPosData.class;
        synchronized (AbstractSegmentPosData.class) {
            if (MapUtil.isEmpty(map)) {
                List<String> lines = this.readDictLines();
                for (String line : lines) {
                    if (StringUtil.isEmptyTrim((String)line)) continue;
                    String[] strings = line.split(" ");
                    String word = strings[0];
                    List posStringList = StringUtil.splitToList((String)strings[1], (String)",");
                    List posList = Guavas.newArrayList((int)posStringList.size());
                    for (String pos : posStringList) {
                        String[] poss = pos.split(":");
                        String name = poss[0];
                        long count = Long.parseLong(poss[1]);
                        posList.add(SegmentPos.of(name, count));
                    }
                    map.put(word, posList);
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            long endMills = System.currentTimeMillis();
            System.out.println("[Segment Pos] segment pos dict init finish, cost " + (endMills - startMills) + " ms!");
            return map;
        }
    }
}

