/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.trie.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.support.data.ISegmentData;
import com.github.houbb.segment.support.trie.ISegmentTrieTree;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public class SegmentTrieTree
implements ISegmentTrieTree {
    private static volatile Map innerWordMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getTrieTree(ISegmentContext context) {
        if (ObjectUtil.isNotNull((Object)innerWordMap)) {
            return innerWordMap;
        }
        Class<SegmentTrieTree> clazz = SegmentTrieTree.class;
        synchronized (SegmentTrieTree.class) {
            ISegmentData segmentData = context.data();
            this.initInnerWordMap(segmentData);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return innerWordMap;
        }
    }

    private void initInnerWordMap(ISegmentData segmentData) {
        innerWordMap = Guavas.newHashMap();
        Set<String> wordSet = segmentData.getWordSet();
        for (String key : wordSet) {
            char[] chars = key.toCharArray();
            int size = chars.length;
            HashMap<Object, Serializable> currentMap = innerWordMap;
            for (int i = 0; i < size; ++i) {
                char charKey = chars[i];
                Object wordMap = currentMap.get(Character.valueOf(charKey));
                if (ObjectUtil.isNotNull(wordMap)) {
                    currentMap = (Map)wordMap;
                } else {
                    HashMap<Object, Serializable> newWordMap = new HashMap<Object, Serializable>(8);
                    newWordMap.put("ED", Boolean.valueOf(false));
                    currentMap.put(Character.valueOf(charKey), newWordMap);
                    currentMap = newWordMap;
                }
                if (i != size - 1) continue;
                currentMap.put("ED", Boolean.valueOf(true));
            }
        }
    }
}

