/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.bs;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.segment.api.ISegment;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.api.ISegmentResult;
import com.github.houbb.segment.bs.ISegmentBs;
import com.github.houbb.segment.data.phrase.api.ISegmentPhraseData;
import com.github.houbb.segment.data.phrase.core.data.SegmentPhraseDatas;
import com.github.houbb.segment.data.pos.api.ISegmentPosData;
import com.github.houbb.segment.data.pos.core.data.SegmentPosDatas;
import com.github.houbb.segment.support.format.ISegmentFormat;
import com.github.houbb.segment.support.format.impl.SegmentFormats;
import com.github.houbb.segment.support.segment.impl.SegmentContext;
import com.github.houbb.segment.support.segment.impl.Segments;
import com.github.houbb.segment.support.segment.mode.ISegmentMode;
import com.github.houbb.segment.support.segment.mode.impl.SegmentModes;
import com.github.houbb.segment.support.segment.result.ISegmentResultHandler;
import com.github.houbb.segment.support.segment.result.impl.SegmentResultHandlers;
import com.github.houbb.segment.support.tagging.pos.tag.ISegmentPosTagging;
import com.github.houbb.segment.support.tagging.pos.tag.impl.SegmentPosTaggings;
import com.github.houbb.segment.support.trie.ISegmentTrieTree;
import com.github.houbb.segment.support.trie.impl.SegmentTrieTrees;
import com.github.houbb.segment.support.viterbi.IViterbi;
import com.github.houbb.segment.support.viterbi.Viterbis;
import java.util.List;

public final class SegmentBs
implements ISegmentBs {
    private ISegment segment = Segments.defaults();
    private ISegmentPhraseData segmentData = SegmentPhraseDatas.mixed();
    private ISegmentMode segmentMode = SegmentModes.search();
    private ISegmentFormat segmentFormat = SegmentFormats.defaults();
    private ISegmentPosTagging posTagging = SegmentPosTaggings.none();
    private ISegmentPosData posData = SegmentPosDatas.mixed();
    private final ISegmentTrieTree segmentTrieTree = SegmentTrieTrees.defaults();
    private final IViterbi viterbi = Viterbis.defaults();

    private SegmentBs() {
    }

    public static SegmentBs newInstance() {
        return new SegmentBs();
    }

    public SegmentBs segment(ISegment segment) {
        ArgUtil.notNull((Object)segment, (String)"segment");
        this.segment = segment;
        return this;
    }

    public SegmentBs segmentData(ISegmentPhraseData segmentData) {
        ArgUtil.notNull((Object)segmentData, (String)"segmentData");
        this.segmentData = segmentData;
        return this;
    }

    public SegmentBs segmentMode(ISegmentMode segmentMode) {
        ArgUtil.notNull((Object)segmentMode, (String)"segmentMode");
        this.segmentMode = segmentMode;
        return this;
    }

    public SegmentBs segmentFormat(ISegmentFormat segmentFormat) {
        ArgUtil.notNull((Object)segmentFormat, (String)"segmentFormat");
        this.segmentFormat = segmentFormat;
        return this;
    }

    public SegmentBs posTagging(ISegmentPosTagging posTagging) {
        this.posTagging = posTagging;
        return this;
    }

    public SegmentBs posData(ISegmentPosData posData) {
        this.posData = posData;
        return this;
    }

    @Override
    public List<ISegmentResult> segment(String string) {
        return this.segment(string, SegmentResultHandlers.common());
    }

    public <R> R segment(String string, ISegmentResultHandler<R> handler) {
        ISegmentContext context = this.buildContext();
        List<ISegmentResult> segmentResults = this.segment.segment(string, context);
        return handler.handler(segmentResults);
    }

    private ISegmentContext buildContext() {
        return SegmentContext.newInstance().data(this.segmentData).mode(this.segmentMode).format(this.segmentFormat).posTagging(this.posTagging).posData(this.posData).segmentTrieTree(this.segmentTrieTree).viterbi(this.viterbi);
    }

    public synchronized void destroy() {
        this.segmentData.destroy();
        this.segmentFormat.destroy();
        this.posData.destroy();
        this.segmentTrieTree.destroy();
        this.viterbi.destroy();
    }
}

