/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.format.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.core.LogFactory;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.support.format.impl.AbstractSegmentFormat;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class ChineseTsSegmentFormat
extends AbstractSegmentFormat {
    private static final Log LOG = LogFactory.getLog(ChineseTsSegmentFormat.class);
    private static volatile Map<Character, Character> TS_CHAR_MAP = Guavas.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initDataMap() {
        if (MapUtil.isNotEmpty(TS_CHAR_MAP)) {
            return;
        }
        LOG.debug("[Segment]-[data-format] init start");
        Map<Character, Character> map = TS_CHAR_MAP;
        synchronized (map) {
            if (MapUtil.isEmpty(TS_CHAR_MAP)) {
                List lines = StreamUtil.readAllLines((String)"/segment_chinese_ts_char.txt");
                for (String line : lines) {
                    String[] entries = line.split(" ");
                    char tChar = entries[0].charAt(0);
                    char sChar = entries[1].charAt(0);
                    TS_CHAR_MAP.put(Character.valueOf(tChar), Character.valueOf(sChar));
                }
            }
        }
        LOG.debug("[Segment]-[data-format] init end");
    }

    @Override
    public char format(char ch, ISegmentContext context) {
        Character simple;
        if (MapUtil.isEmpty(TS_CHAR_MAP)) {
            this.initDataMap();
        }
        if (ObjectUtil.isNull((Object)(simple = TS_CHAR_MAP.get(Character.valueOf(ch))))) {
            return ch;
        }
        return simple.charValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        LOG.debug("[Segment]-[data-format] destroy start");
        Map<Character, Character> map = TS_CHAR_MAP;
        synchronized (map) {
            TS_CHAR_MAP.clear();
        }
        LOG.debug("[Segment]-[data-format] destroy end");
    }
}

