/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.segment.strategy.impl;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.api.ISegmentResult;
import com.github.houbb.segment.support.segment.impl.SegmentResult;
import com.github.houbb.segment.support.segment.strategy.ISegmentStrategy;
import java.util.List;

public abstract class AbstractSegmentStrategy
implements ISegmentStrategy {
    protected abstract List<Integer> doSegment(String var1, int var2, ISegmentContext var3);

    @Override
    public List<ISegmentResult> segment(String string, int startIndex, ISegmentContext context) {
        List<Integer> endIndexList = this.doSegment(string, startIndex, context);
        return this.buildSegmentResultList(string, startIndex, endIndexList);
    }

    private List<ISegmentResult> buildSegmentResultList(String text, int startIndex, List<Integer> endIndexList) {
        List resultList = Guavas.newArrayList((int)endIndexList.size());
        for (int endIndex : endIndexList) {
            String word = text.substring(startIndex, endIndex);
            SegmentResult segmentResult = SegmentResult.newInstance().startIndex(startIndex).endIndex(endIndex).word(word);
            resultList.add(segmentResult);
        }
        return resultList;
    }
}

