/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.segment.strategy.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.support.segment.strategy.impl.AbstractSegmentStrategy;
import com.github.houbb.segment.support.trie.impl.SegmentTrieTrees;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class TireTreeSegmentStrategy
extends AbstractSegmentStrategy {
    @Override
    public List<Integer> doSegment(String string, int startIndex, ISegmentContext context) {
        Map nowMap = SegmentTrieTrees.defaults().getTrieTree(context);
        List resultList = Guavas.newArrayList();
        for (int i = startIndex; i < string.length() && ObjectUtil.isNotNull((Object)(nowMap = this.getCurrentMap(nowMap, string, i, context))); ++i) {
            boolean isEnd = TireTreeSegmentStrategy.isEnd(nowMap);
            if (!isEnd) continue;
            int endIndex = i + 1;
            resultList.add(endIndex);
        }
        return resultList;
    }

    private Map getCurrentMap(Map nowMap, String txt, int index, ISegmentContext context) {
        char charAt = txt.charAt(index);
        char mappingChar = context.format().format(charAt, context);
        Map currentMap = (Map)nowMap.get(Character.valueOf(mappingChar));
        return currentMap;
    }

    private static boolean isEnd(Map map) {
        if (ObjectUtil.isNull((Object)map)) {
            return false;
        }
        Object value = map.get("ED");
        if (ObjectUtil.isNull(value)) {
            return false;
        }
        return (Boolean)value;
    }
}

