/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.segment.support.trie.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.core.LogFactory;
import com.github.houbb.segment.api.ISegmentContext;
import com.github.houbb.segment.data.phrase.api.ISegmentPhraseData;
import com.github.houbb.segment.support.trie.impl.AbstractSegmentTrieTree;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public class SegmentTrieTree
extends AbstractSegmentTrieTree {
    private static final Log LOG = LogFactory.getLog(SegmentTrieTree.class);
    private static volatile Map innerWordMap = Guavas.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getTrieTree(ISegmentContext context) {
        if (ObjectUtil.isNotEmpty((Object)innerWordMap)) {
            return innerWordMap;
        }
        LOG.debug("[Segment]-[data-trie] init start");
        Class<SegmentTrieTree> clazz = SegmentTrieTree.class;
        synchronized (SegmentTrieTree.class) {
            if (MapUtil.isEmpty((Map)innerWordMap)) {
                ISegmentPhraseData segmentData = context.data();
                this.initInnerWordMap(segmentData);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            LOG.debug("[Segment]-[data-trie] init end");
            return innerWordMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        LOG.debug("[Segment]-[data-trie] destroy start");
        Map map = innerWordMap;
        synchronized (map) {
            innerWordMap.clear();
        }
        LOG.debug("[Segment]-[data-trie] destroy end");
    }

    private void initInnerWordMap(ISegmentPhraseData segmentData) {
        Set wordSet = segmentData.getPhraseSet();
        for (String key : wordSet) {
            char[] chars = key.toCharArray();
            int size = chars.length;
            HashMap<Object, Serializable> currentMap = innerWordMap;
            for (int i = 0; i < size; ++i) {
                char charKey = chars[i];
                Object wordMap = currentMap.get(Character.valueOf(charKey));
                if (ObjectUtil.isNotNull(wordMap)) {
                    currentMap = (Map)wordMap;
                } else {
                    HashMap<Object, Serializable> newWordMap = new HashMap<Object, Serializable>(8);
                    newWordMap.put("ED", Boolean.valueOf(false));
                    currentMap.put(Character.valueOf(charKey), newWordMap);
                    currentMap = newWordMap;
                }
                if (i != size - 1) continue;
                currentMap.put("ED", Boolean.valueOf(true));
            }
        }
    }
}

