/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.util.regex.RegexUtil;
import com.github.houbb.sensitive.word.api.IWordCheck;
import com.github.houbb.sensitive.word.api.context.InnerSensitiveWordContext;
import com.github.houbb.sensitive.word.support.check.AbstractConditionWordCheck;

@ThreadSafe
public class WordCheckEmail
extends AbstractConditionWordCheck {
    private static final IWordCheck INSTANCE = new WordCheckEmail();

    public static IWordCheck getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<? extends IWordCheck> getSensitiveCheckClass() {
        return WordCheckEmail.class;
    }

    @Override
    protected boolean isCharCondition(char mappingChar, int index, InnerSensitiveWordContext checkContext) {
        return CharUtil.isEmilChar((char)mappingChar);
    }

    @Override
    protected boolean isStringCondition(int index, StringBuilder stringBuilder, InnerSensitiveWordContext checkContext) {
        int bufferLen = stringBuilder.length();
        if (bufferLen < 6) {
            return false;
        }
        if (bufferLen > 64) {
            return false;
        }
        String string = stringBuilder.toString();
        return RegexUtil.isEmail((String)string);
    }
}

