/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.constant.enums.ValidModeEnum;
import com.github.houbb.sensitive.word.support.check.ISensitiveCheck;
import com.github.houbb.sensitive.word.support.check.SensitiveCheckResult;
import com.github.houbb.sensitive.word.support.check.impl.SensitiveCheckEmail;
import com.github.houbb.sensitive.word.support.check.impl.SensitiveCheckNum;
import com.github.houbb.sensitive.word.support.check.impl.SensitiveCheckUrl;
import com.github.houbb.sensitive.word.support.check.impl.SensitiveCheckWord;
import java.util.List;

@ThreadSafe
public class SensitiveCheckChain
implements ISensitiveCheck {
    @Override
    public SensitiveCheckResult sensitiveCheck(String txt, int beginIndex, ValidModeEnum validModeEnum, IWordContext context) {
        List sensitiveChecks = Guavas.newArrayList();
        sensitiveChecks.add(Instances.singleton(SensitiveCheckWord.class));
        if (context.sensitiveCheckNum()) {
            sensitiveChecks.add(Instances.singleton(SensitiveCheckNum.class));
        }
        if (context.sensitiveCheckEmail()) {
            sensitiveChecks.add(Instances.singleton(SensitiveCheckEmail.class));
        }
        if (context.sensitiveCheckUrl()) {
            sensitiveChecks.add(Instances.singleton(SensitiveCheckUrl.class));
        }
        for (ISensitiveCheck sensitiveCheck : sensitiveChecks) {
            SensitiveCheckResult result = sensitiveCheck.sensitiveCheck(txt, beginIndex, validModeEnum, context);
            if (result.index() <= 0) continue;
            return result;
        }
        return SensitiveCheckResult.of(0, SensitiveCheckChain.class);
    }
}

