/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.constant.enums.ValidModeEnum;
import com.github.houbb.sensitive.word.support.check.ISensitiveCheck;
import com.github.houbb.sensitive.word.support.check.SensitiveCheckResult;
import com.github.houbb.sensitive.word.support.format.CharFormatChain;

@ThreadSafe
public class SensitiveCheckNum
implements ISensitiveCheck {
    @Override
    public SensitiveCheckResult sensitiveCheck(String txt, int beginIndex, ValidModeEnum validModeEnum, IWordContext context) {
        int lengthCount = 0;
        int actualLength = 0;
        for (int i = beginIndex; i < txt.length(); ++i) {
            boolean isCondition;
            char c = txt.charAt(i);
            char charKey = ((CharFormatChain)Instances.singleton(CharFormatChain.class)).format(c, context);
            if (!Character.isDigit(charKey)) break;
            if (!(isCondition = this.isCondition(++lengthCount))) continue;
            actualLength = lengthCount;
            if (ValidModeEnum.FAIL_FAST.equals((Object)validModeEnum)) break;
        }
        return SensitiveCheckResult.of(actualLength, SensitiveCheckNum.class);
    }

    private boolean isCondition(int lengthCount) {
        return lengthCount >= 8;
    }
}

