/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.constant.enums.ValidModeEnum;
import com.github.houbb.sensitive.word.support.check.ISensitiveCheck;
import com.github.houbb.sensitive.word.support.check.SensitiveCheckResult;
import com.github.houbb.sensitive.word.support.format.CharFormatChain;
import java.util.Map;

@ThreadSafe
public class SensitiveCheckWord
implements ISensitiveCheck {
    @Override
    public SensitiveCheckResult sensitiveCheck(String txt, int beginIndex, ValidModeEnum validModeEnum, IWordContext context) {
        Map nowMap = context.sensitiveWordMap();
        int lengthCount = 0;
        int actualLength = 0;
        for (int i = beginIndex; i < txt.length() && ObjectUtil.isNotNull((Object)(nowMap = this.getNowMap(nowMap, context, txt, i))); ++i) {
            ++lengthCount;
            boolean isEnd = SensitiveCheckWord.isEnd(nowMap);
            if (!isEnd) continue;
            actualLength = lengthCount;
            if (ValidModeEnum.FAIL_FAST.equals((Object)validModeEnum)) break;
        }
        return SensitiveCheckResult.of(actualLength, SensitiveCheckWord.class);
    }

    private static boolean isEnd(Map map) {
        if (ObjectUtil.isNull((Object)map)) {
            return false;
        }
        Object value = map.get("ED");
        if (ObjectUtil.isNull(value)) {
            return false;
        }
        return (Boolean)value;
    }

    private Map getNowMap(Map nowMap, IWordContext context, String txt, int index) {
        char c = txt.charAt(index);
        char mappingChar = ((CharFormatChain)Instances.singleton(CharFormatChain.class)).format(c, context);
        Map currentMap = (Map)nowMap.get(Character.valueOf(mappingChar));
        if (context.ignoreRepeat() && index > 0) {
            char preChar = txt.charAt(index - 1);
            char preMappingChar = ((CharFormatChain)Instances.singleton(CharFormatChain.class)).format(preChar, context);
            if (preMappingChar == mappingChar) {
                currentMap = nowMap;
            }
        }
        return currentMap;
    }
}

