/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.sensitive.word.api.ISensitiveWordCharIgnore;
import com.github.houbb.sensitive.word.api.IWordCheck;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordData;
import com.github.houbb.sensitive.word.api.context.InnerSensitiveWordContext;
import com.github.houbb.sensitive.word.constant.enums.WordContainsTypeEnum;
import com.github.houbb.sensitive.word.constant.enums.WordTypeEnum;
import com.github.houbb.sensitive.word.support.check.AbstractWordCheck;
import com.github.houbb.sensitive.word.support.result.WordLengthResult;
import java.util.Map;

@ThreadSafe
public class WordCheckWord
extends AbstractWordCheck {
    private static final IWordCheck INSTANCE = new WordCheckWord();

    public static IWordCheck getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<? extends IWordCheck> getSensitiveCheckClass() {
        return WordCheckWord.class;
    }

    @Override
    protected WordLengthResult getActualLength(int beginIndex, InnerSensitiveWordContext innerContext) {
        String txt = innerContext.originalText();
        Map<Character, Character> formatCharMapping = innerContext.formatCharMapping();
        IWordContext context = innerContext.wordContext();
        IWordData wordData = context.wordData();
        IWordData wordDataAllow = context.wordDataAllow();
        ISensitiveWordCharIgnore wordCharIgnore = context.charIgnore();
        StringBuilder stringBuilder = new StringBuilder();
        char[] rawChars = txt.toCharArray();
        int tempLen = 0;
        int maxWhite = 0;
        int maxBlack = 0;
        boolean firstCheck = true;
        WordContainsTypeEnum wordContainsTypeEnumAllow = wordDataAllow.contains(stringBuilder, innerContext);
        WordContainsTypeEnum wordContainsTypeEnumDeny = wordData.contains(stringBuilder, innerContext);
        for (int i = beginIndex; i < rawChars.length; ++i) {
            if (wordCharIgnore.ignore(i, rawChars, innerContext) && tempLen != 0) {
                ++tempLen;
                continue;
            }
            char mappingChar = formatCharMapping.get(Character.valueOf(rawChars[i])).charValue();
            stringBuilder.append(mappingChar);
            ++tempLen;
            if ((firstCheck || !WordContainsTypeEnum.NOT_FOUND.equals((Object)wordContainsTypeEnumAllow)) && WordContainsTypeEnum.CONTAINS_END.equals((Object)(wordContainsTypeEnumAllow = wordDataAllow.contains(stringBuilder, innerContext)))) {
                maxWhite += tempLen;
                wordContainsTypeEnumAllow = WordContainsTypeEnum.NOT_FOUND;
            }
            if ((firstCheck || !WordContainsTypeEnum.NOT_FOUND.equals((Object)wordContainsTypeEnumDeny)) && WordContainsTypeEnum.CONTAINS_END.equals((Object)(wordContainsTypeEnumDeny = wordData.contains(stringBuilder, innerContext)))) {
                maxBlack += tempLen;
                wordContainsTypeEnumDeny = WordContainsTypeEnum.NOT_FOUND;
            }
            firstCheck = false;
            if (WordContainsTypeEnum.NOT_FOUND.equals((Object)wordContainsTypeEnumAllow) && WordContainsTypeEnum.NOT_FOUND.equals((Object)wordContainsTypeEnumDeny)) break;
        }
        return WordLengthResult.newInstance().wordAllowLen(maxWhite).wordDenyLen(maxBlack);
    }

    @Override
    protected String getType() {
        return WordTypeEnum.WORD.getCode();
    }
}

