/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.data;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.context.InnerSensitiveWordContext;
import com.github.houbb.sensitive.word.constant.enums.WordContainsTypeEnum;
import com.github.houbb.sensitive.word.support.data.AbstractWordData;
import com.github.houbb.sensitive.word.support.data.WordDataTreeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@ThreadSafe
public class WordDataTree
extends AbstractWordData {
    private WordDataTreeNode root;

    @Override
    public synchronized void initWordData(Collection<String> collection) {
        WordDataTreeNode newRoot = new WordDataTreeNode();
        for (String word : collection) {
            if (StringUtil.isEmpty((String)word)) continue;
            this.addWord(newRoot, word);
        }
        this.root = newRoot;
    }

    @Override
    protected WordContainsTypeEnum doContains(StringBuilder stringBuilder, InnerSensitiveWordContext innerContext) {
        WordDataTreeNode nowNode = this.root;
        int len = stringBuilder.length();
        for (int i = 0; i < len; ++i) {
            if (!ObjectUtil.isNull((Object)(nowNode = this.getNowMap(nowNode, i, stringBuilder, innerContext)))) continue;
            return WordContainsTypeEnum.NOT_FOUND;
        }
        if (nowNode.end()) {
            return WordContainsTypeEnum.CONTAINS_END;
        }
        return WordContainsTypeEnum.CONTAINS_PREFIX;
    }

    @Override
    protected void doInitWordData(Collection<String> collection) {
        WordDataTreeNode newRoot = new WordDataTreeNode();
        for (String word : collection) {
            if (StringUtil.isEmpty((String)word)) continue;
            this.addWord(newRoot, word);
        }
        this.root = newRoot;
    }

    @Override
    public synchronized void doAddWord(Collection<String> collection) {
        for (String word : collection) {
            if (StringUtil.isEmpty((String)word)) continue;
            this.addWord(this.root, word);
        }
    }

    @Override
    protected synchronized void doRemoveWord(Collection<String> collection) {
        for (String word : collection) {
            if (StringUtil.isEmpty((String)word)) continue;
            this.removeWord(this.root, word);
        }
    }

    private WordDataTreeNode getNowMap(WordDataTreeNode nowNode, int index, StringBuilder stringBuilder, InnerSensitiveWordContext sensitiveContext) {
        char preMappingChar;
        IWordContext context = sensitiveContext.wordContext();
        char mappingChar = stringBuilder.charAt(index);
        WordDataTreeNode currentMap = nowNode.getSubNode(mappingChar);
        if (context.ignoreRepeat() && index > 0 && (preMappingChar = stringBuilder.charAt(index - 1)) == mappingChar) {
            currentMap = nowNode;
        }
        return currentMap;
    }

    @Override
    public void destroy() {
        if (this.root != null) {
            this.root.destroy();
        }
    }

    private void addWord(WordDataTreeNode newRoot, String word) {
        char[] chars;
        WordDataTreeNode tempNode = newRoot;
        for (char c : chars = word.toCharArray()) {
            WordDataTreeNode subNode = tempNode.getSubNode(c);
            if (subNode == null) {
                subNode = new WordDataTreeNode();
                tempNode.addSubNode(c, subNode);
            }
            tempNode = subNode;
        }
        tempNode.end(true);
    }

    private void removeWord(WordDataTreeNode root, String word) {
        WordDataTreeNode tempNode = root;
        HashMap<Character, WordDataTreeNode> map = new HashMap<Character, WordDataTreeNode>();
        char[] chars = word.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            WordDataTreeNode subNode = tempNode.getSubNode(chars[i]);
            if (subNode == null) {
                return;
            }
            if (i == length - 1) {
                if (!subNode.end()) {
                    return;
                }
                if (subNode.getNodeSize() > 0) {
                    subNode.end(false);
                    return;
                }
            }
            if (subNode.end()) {
                map.clear();
            }
            map.put(Character.valueOf(chars[i]), tempNode);
            tempNode = subNode;
        }
        for (Map.Entry entry : map.entrySet()) {
            WordDataTreeNode value = (WordDataTreeNode)entry.getValue();
            if (value.getNodeSize() == 1) {
                value.clearNode();
                return;
            }
            value.removeNode(((Character)entry.getKey()).charValue());
        }
    }
}

