/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.resultcondition;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordResult;
import com.github.houbb.sensitive.word.api.IWordTag;
import com.github.houbb.sensitive.word.constant.enums.WordValidModeEnum;
import com.github.houbb.sensitive.word.support.resultcondition.AbstractWordResultCondition;
import java.util.Collection;
import java.util.Set;

public class WordResultConditionWordTagsMatch
extends AbstractWordResultCondition {
    private final Collection<String> tags;

    public WordResultConditionWordTagsMatch(Collection<String> tags) {
        ArgUtil.notEmpty(tags, (String)"tags");
        this.tags = tags;
    }

    @Override
    protected boolean doMatch(IWordResult wordResult, String text, WordValidModeEnum modeEnum, IWordContext context) {
        String word = text.substring(wordResult.startIndex(), wordResult.endIndex());
        IWordTag wordTag = context.wordTag();
        Set<String> wordTags = wordTag.getTag(word);
        if (CollectionUtil.isEmpty(wordTags)) {
            return false;
        }
        for (String tag : this.tags) {
            if (!wordTags.contains(tag)) continue;
            return true;
        }
        return false;
    }
}

