/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.resultcondition;

import com.github.houbb.heaven.support.pipeline.Pipeline;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.sensitive.word.api.IWordResultCondition;
import com.github.houbb.sensitive.word.support.resultcondition.WordResultConditionAlwaysTrue;
import com.github.houbb.sensitive.word.support.resultcondition.WordResultConditionEnglishWordMatch;
import com.github.houbb.sensitive.word.support.resultcondition.WordResultConditionEnglishWordNumMatch;
import com.github.houbb.sensitive.word.support.resultcondition.WordResultConditionInit;
import com.github.houbb.sensitive.word.support.resultcondition.WordResultConditionWordTagsMatch;
import java.util.List;

public final class WordResultConditions {
    public static IWordResultCondition alwaysTrue() {
        return new WordResultConditionAlwaysTrue();
    }

    public static IWordResultCondition englishWordMatch() {
        return new WordResultConditionEnglishWordMatch();
    }

    public static IWordResultCondition englishWordNumMatch() {
        return new WordResultConditionEnglishWordNumMatch();
    }

    public static IWordResultCondition wordTags(List<String> tags) {
        ArgUtil.notEmpty(tags, (String)"tags");
        return new WordResultConditionWordTagsMatch(tags);
    }

    public static IWordResultCondition chains(final IWordResultCondition condition, final IWordResultCondition ... others) {
        return new WordResultConditionInit(){

            @Override
            protected void init(Pipeline<IWordResultCondition> pipeline) {
                pipeline.addLast((Object)condition);
                if (ArrayUtil.isNotEmpty((Object[])others)) {
                    for (IWordResultCondition other : others) {
                        pipeline.addLast((Object)other);
                    }
                }
            }
        };
    }
}

