/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.tag;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.sensitive.word.api.IWordTag;
import com.github.houbb.sensitive.word.support.tag.AbstractWordTag;
import com.github.houbb.sensitive.word.support.tag.WordTags;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WordTagLines
extends AbstractWordTag {
    private final IWordTag wordTag;
    private final String wordSplit;
    private final String tagSplit;

    public WordTagLines(Collection<String> lines, String wordSplit, String tagSplit) {
        ArgUtil.notNull(lines, (String)"lines");
        ArgUtil.notEmpty((String)wordSplit, (String)"wordSplit");
        ArgUtil.notEmpty((String)tagSplit, (String)"tagSplit");
        this.wordSplit = wordSplit;
        this.tagSplit = tagSplit;
        Map<String, Set<String>> wordTagMap = this.buildWordTagMap(lines);
        this.wordTag = WordTags.map(wordTagMap);
    }

    public WordTagLines(Collection<String> lines) {
        this(lines, " ", ",");
    }

    private Map<String, Set<String>> buildWordTagMap(Collection<String> lines) {
        HashMap<String, Set<String>> wordTagMap = new HashMap<String, Set<String>>();
        for (String line : lines) {
            String[] strings = line.split(this.wordSplit);
            String key = strings[0];
            HashSet tags = new HashSet(StringUtil.splitToList((String)strings[1], (String)this.tagSplit));
            wordTagMap.put(key, tags);
        }
        return wordTagMap;
    }

    @Override
    protected Set<String> doGetTag(String word) {
        return this.wordTag.getTag(word);
    }
}

