/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.tag;

import com.github.houbb.heaven.support.pipeline.Pipeline;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.sensitive.word.api.IWordTag;
import com.github.houbb.sensitive.word.support.tag.AbstractWordTagInit;
import com.github.houbb.sensitive.word.support.tag.FileWordTag;
import com.github.houbb.sensitive.word.support.tag.NoneWordTag;
import com.github.houbb.sensitive.word.support.tag.WordTagLines;
import com.github.houbb.sensitive.word.support.tag.WordTagMap;
import com.github.houbb.sensitive.word.support.tag.WordTagSystem;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class WordTags {
    public static IWordTag none() {
        return new NoneWordTag();
    }

    public static IWordTag file(String filePath) {
        return new FileWordTag(filePath);
    }

    public static IWordTag file(String filePath, String wordSplit, String tagSplit) {
        return new FileWordTag(filePath, wordSplit, tagSplit);
    }

    public static IWordTag map(Map<String, Set<String>> wordTagMap) {
        return new WordTagMap(wordTagMap);
    }

    public static IWordTag lines(Collection<String> lines) {
        return new WordTagLines(lines);
    }

    public static IWordTag lines(Collection<String> lines, String wordSplit, String tagSplit) {
        return new WordTagLines(lines, wordSplit, tagSplit);
    }

    public static IWordTag system() {
        return new WordTagSystem();
    }

    public static IWordTag defaults() {
        return WordTags.system();
    }

    public static IWordTag chains(final IWordTag wordTag, final IWordTag ... others) {
        ArgUtil.notNull((Object)wordTag, (String)"wordTag");
        return new AbstractWordTagInit(){

            @Override
            protected void init(Pipeline<IWordTag> pipeline) {
                pipeline.addLast((Object)wordTag);
                if (ArrayUtil.isNotEmpty((Object[])others)) {
                    for (IWordTag other : others) {
                        pipeline.addLast((Object)other);
                    }
                }
            }
        };
    }
}

