/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sftp.api;

import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.core.LogFactory;
import com.github.houbb.sftp.api.ISftp;
import com.github.houbb.sftp.exception.SftpRuntimeException;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class Sftp
implements ISftp {
    private Log log = LogFactory.getLog(Sftp.class);
    private ChannelSftp sftp;
    private Session session;

    @Override
    public void login(String host, int port, String username, String password, String privateKey) {
        try {
            JSch jsch = new JSch();
            if (privateKey != null) {
                jsch.addIdentity(privateKey);
                this.log.info("sftp connect,path of private key file\uff1a{}", new Object[]{privateKey});
            }
            this.log.info("sftp connect by host:{} username:{}", new Object[]{host, username});
            this.session = jsch.getSession(username, host, port);
            this.log.info("Session is build");
            if (password != null) {
                this.session.setPassword(password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
            this.session.setConfig(config);
            this.session.connect();
            this.log.info("Session is connected");
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            this.log.info("channel is connected");
            this.sftp = (ChannelSftp)channel;
            this.log.info(String.format("sftp server host:[%s] port:[%s] is connect successful!", host, port));
        }
        catch (JSchException e) {
            this.log.error("Cannot connect to specified sftp server : {}:{}", new Object[]{host, port, e});
            throw new SftpRuntimeException(e);
        }
    }

    @Override
    public void logout() {
        if (this.sftp != null && this.sftp.isConnected()) {
            this.sftp.disconnect();
            this.log.info("sftp is closed already");
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
            this.log.info("sshSession is closed already");
        }
    }

    @Override
    public void upload(String sftpDirectory, String sftpFileName, String localFilePath) {
        File file = new File(localFilePath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.sftp.cd(sftpDirectory);
            this.sftp.put((InputStream)inputStream, sftpFileName);
            this.log.info("file:{} is upload successful", new Object[]{sftpFileName});
        }
        catch (SftpException | IOException e) {
            throw new SftpRuntimeException(e);
        }
    }

    @Override
    public void download(String sftpDirectory, String sftpFileName, String localFilePath) {
        File file = new File(localFilePath);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.sftp.cd(sftpDirectory);
            this.sftp.get(sftpFileName, (OutputStream)outputStream);
            this.log.info("file:{} is download successful", new Object[]{sftpFileName});
        }
        catch (SftpException | IOException e) {
            throw new SftpRuntimeException(e);
        }
    }

    @Override
    public void delete(String sftpDirectory, String sftpFileName) {
        try {
            this.sftp.cd(sftpDirectory);
            this.sftp.rm(sftpFileName);
        }
        catch (SftpException e) {
            throw new SftpRuntimeException(e);
        }
    }

    @Override
    public void mkdir(String sftpDirectory) {
        try {
            this.sftp.mkdir(sftpDirectory);
        }
        catch (SftpException e) {
            throw new SftpRuntimeException(e);
        }
    }

    @Override
    public List<ChannelSftp.LsEntry> list(String sftpDirectory) {
        try {
            ArrayList<ChannelSftp.LsEntry> list = new ArrayList<ChannelSftp.LsEntry>();
            Vector vector = this.sftp.ls(sftpDirectory);
            if (vector.isEmpty()) {
                return list;
            }
            for (Object object : vector) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)object;
                list.add(entry);
            }
            return list;
        }
        catch (SftpException e) {
            throw new SftpRuntimeException(e);
        }
    }
}

