/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sftp.bs;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.sftp.api.ISftp;
import com.github.houbb.sftp.api.Sftp;
import com.github.houbb.sftp.bs.ISftpBs;
import com.jcraft.jsch.ChannelSftp;
import java.util.List;

public final class SftpBs
implements ISftpBs {
    private final ISftp sftp = new Sftp();
    private String username = "sftp";
    private String password = "123456";
    private String privateKey = null;
    private String host = "127.0.0.1";
    private int port = 22;
    private String baseDir = "/";

    private SftpBs() {
    }

    public static SftpBs newInstance() {
        return new SftpBs();
    }

    public SftpBs username(String username) {
        ArgUtil.notEmpty((String)username, (String)"username");
        this.username = username;
        return this;
    }

    public SftpBs password(String password) {
        this.password = password;
        return this;
    }

    public SftpBs privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public SftpBs host(String host) {
        ArgUtil.notEmpty((String)host, (String)"host");
        this.host = host;
        return this;
    }

    public SftpBs port(int port) {
        ArgUtil.notNegative((int)port, (String)"port");
        this.port = port;
        return this;
    }

    public SftpBs baseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    @Override
    public ISftpBs login() {
        this.sftp.login(this.host, this.port, this.username, this.password, this.privateKey);
        return this;
    }

    @Override
    public ISftpBs logout() {
        this.sftp.logout();
        return this;
    }

    @Override
    public ISftpBs upload(String sftpFileName, String localFilePath) {
        this.sftp.upload(this.baseDir, sftpFileName, localFilePath);
        return this;
    }

    @Override
    public ISftpBs download(String sftpFileName, String localFilePath) {
        this.sftp.download(this.baseDir, sftpFileName, localFilePath);
        return this;
    }

    @Override
    public ISftpBs delete(String sftpFileName) {
        this.sftp.delete(this.baseDir, sftpFileName);
        return this;
    }

    @Override
    public ISftpBs mkdir() {
        this.sftp.mkdir(this.baseDir);
        return this;
    }

    @Override
    public List<ChannelSftp.LsEntry> list() {
        return this.sftp.list(this.baseDir);
    }
}

