/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.word.cloud.bs;

import com.github.houbb.word.cloud.support.freq.DefaultWordFrequency;
import com.github.houbb.word.cloud.support.freq.IWordFrequency;
import com.github.houbb.word.cloud.support.freq.WordFrequencyContext;
import com.kennycason.kumo.CollisionMode;
import com.kennycason.kumo.WordCloud;
import com.kennycason.kumo.WordFrequency;
import com.kennycason.kumo.bg.Background;
import com.kennycason.kumo.font.FontWeight;
import com.kennycason.kumo.font.KumoFont;
import com.kennycason.kumo.font.scale.FontScalar;
import com.kennycason.kumo.font.scale.LinearFontScalar;
import com.kennycason.kumo.palette.ColorPalette;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class WordCloudBs {
    private String outPath = "out.png";
    private IWordFrequency wordFrequency = new DefaultWordFrequency();
    private String text = "\u6211\u7231\u4e91\u56fe\uff0c\u4e91\u56fe\u7231\u6211";
    private int limit = Integer.MAX_VALUE;
    private int width = 800;
    private int height = 600;
    private CollisionMode collisionMode = CollisionMode.PIXEL_PERFECT;
    private int padding = 0;
    private Color backgroundColor = Color.WHITE;
    private Background background;
    private FontScalar fontScalar = new LinearFontScalar(10, 40);
    private KumoFont kumoFont = new KumoFont("Default", FontWeight.BOLD);
    private ColorPalette colorPalette = WordCloudBs.buildRandomColorPalette(5);

    private WordCloudBs() {
    }

    public static WordCloudBs newInstance() {
        return new WordCloudBs();
    }

    public WordCloudBs outPath(String outPath) {
        this.outPath = outPath;
        return this;
    }

    public WordCloudBs wordFrequency(IWordFrequency wordFrequency) {
        this.wordFrequency = wordFrequency;
        return this;
    }

    public WordCloudBs text(String text) {
        this.text = text;
        return this;
    }

    public WordCloudBs limit(int limit) {
        this.limit = limit;
        return this;
    }

    public WordCloudBs width(int width) {
        this.width = width;
        return this;
    }

    public WordCloudBs height(int height) {
        this.height = height;
        return this;
    }

    public WordCloudBs collisionMode(CollisionMode collisionMode) {
        this.collisionMode = collisionMode;
        return this;
    }

    public WordCloudBs padding(int padding) {
        this.padding = padding;
        return this;
    }

    public WordCloudBs backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public WordCloudBs background(Background background) {
        this.background = background;
        return this;
    }

    public WordCloudBs fontScalar(FontScalar fontScalar) {
        this.fontScalar = fontScalar;
        return this;
    }

    public WordCloudBs kumoFont(KumoFont kumoFont) {
        this.kumoFont = kumoFont;
        return this;
    }

    public WordCloudBs colorPalette(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
        return this;
    }

    public void wordCloud() {
        WordFrequencyContext frequencyContext = new WordFrequencyContext();
        frequencyContext.text(this.text).limit(this.limit);
        List<WordFrequency> wordFrequencies = this.wordFrequency.freq(frequencyContext);
        Dimension dimension = new Dimension(this.width, this.height);
        WordCloud wordCloud = new WordCloud(dimension, this.collisionMode);
        wordCloud.setPadding(this.padding);
        wordCloud.setBackgroundColor(this.backgroundColor);
        if (this.background != null) {
            wordCloud.setBackground(this.background);
        }
        wordCloud.setKumoFont(this.kumoFont);
        wordCloud.setColorPalette(this.colorPalette);
        wordCloud.setFontScalar(this.fontScalar);
        wordCloud.build(wordFrequencies);
        wordCloud.writeToFile(this.outPath);
    }

    private static ColorPalette buildRandomColorPalette(int n) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Color[] colors = new Color[n];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color(((Random)random).nextInt(230) + 25, ((Random)random).nextInt(230) + 25, ((Random)random).nextInt(230) + 25);
        }
        return new ColorPalette(colors);
    }
}

