/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ClickHouseDialect$
extends JdbcDialect
implements Logging {
    public static final ClickHouseDialect$ MODULE$;
    private final Regex arrayTypePattern;
    private final Regex dateTypePattern;
    private final Regex dateTimeTypePattern;
    private final Regex decimalTypePattern;
    private final Regex decimalTypePattern2;
    private final Regex enumTypePattern;
    private final Regex fixedStringTypePattern;
    private final Regex nullableTypePattern;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ClickHouseDialect$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Regex arrayTypePattern() {
        return this.arrayTypePattern;
    }

    public Regex dateTypePattern() {
        return this.dateTypePattern;
    }

    public Regex dateTimeTypePattern() {
        return this.dateTimeTypePattern;
    }

    public Regex decimalTypePattern() {
        return this.decimalTypePattern;
    }

    public Regex decimalTypePattern2() {
        return this.decimalTypePattern2;
    }

    public Regex enumTypePattern() {
        return this.enumTypePattern;
    }

    public Regex fixedStringTypePattern() {
        return this.fixedStringTypePattern;
    }

    public Regex nullableTypePattern() {
        return this.nullableTypePattern;
    }

    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:clickhouse");
    }

    /*
     * Unable to fully structure code
     */
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        scale = (int)md.build().getLong("scale");
        this.logDebug((Function0<String>)new Serializable(sqlType, typeName, size, scale){
            public static final long serialVersionUID = 0L;
            private final int sqlType$1;
            private final String typeName$1;
            private final int size$1;
            private final int scale$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sqlType: ", ", typeName: ", ", precision: ", ", scale: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.sqlType$1), this.typeName$1, BoxesRunTime.boxToInteger((int)this.size$1), BoxesRunTime.boxToInteger((int)this.scale$1)}));
            }
            {
                this.sqlType$1 = sqlType$1;
                this.typeName$1 = typeName$1;
                this.size$1 = size$1;
                this.scale$1 = scale$1;
            }
        });
        var6_6 = sqlType;
        switch (var6_6) {
            default: {
                v0 = this.toCatalystType(typeName, size, scale).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply(Tuple2<Object, DataType> x$1) {
                        return (DataType)x$1._2();
                    }
                });
                break;
            }
            case 2003: {
                var7_7 = this.unwrapNullable(typeName);
                if (var7_7 == null) ** GOTO lbl-1000
                var8_8 = (CharSequence)var7_7._2();
                var9_9 = this.arrayTypePattern().unapplySeq(var8_8);
                if (!var9_9.isEmpty() && var9_9.get() != null && ((LinearSeqOptimized)var9_9.get()).lengthCompare(1) == 0) {
                    nestType = (String)((LinearSeqOptimized)var9_9.get()).apply(0);
                    var11_11 = this.toCatalystType(nestType, size, scale).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(Tuple2<Object, DataType> x0$1) {
                            Tuple2<Object, DataType> tuple2 = x0$1;
                            if (tuple2 != null) {
                                boolean nullable = tuple2._1$mcZ$sp();
                                DataType dataType = (DataType)tuple2._2();
                                ArrayType arrayType = new ArrayType(dataType, nullable);
                                return arrayType;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                } else lbl-1000:
                // 2 sources

                {
                    var11_11 = None$.MODULE$;
                }
                v0 = var11_11;
            }
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple2<Object, DataType>> toCatalystType(String typeName, int precision, int scale) {
        Some some;
        Option option;
        Option option2;
        Tuple2 tuple2;
        Tuple2<Object, String> tuple22 = this.unwrapNullable(typeName);
        if (tuple22 == null) throw new MatchError(tuple22);
        boolean nullable = tuple22._1$mcZ$sp();
        String _typeName = (String)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)nullable), (Object)_typeName);
        boolean nullable2 = tuple23._1$mcZ$sp();
        String _typeName2 = (String)tuple23._2();
        String string = _typeName2;
        boolean bl = "String".equals(string) ? true : ("UUID".equals(string) ? true : (!(option2 = this.fixedStringTypePattern().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0 ? true : !(option = this.enumTypePattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0));
        if (bl) {
            some = new Some((Object)StringType$.MODULE$);
        } else if ("Int8".equals(string)) {
            some = new Some((Object)ByteType$.MODULE$);
        } else {
            boolean bl2 = "UInt8".equals(string) ? true : "Int16".equals(string);
            if (bl2) {
                some = new Some((Object)ShortType$.MODULE$);
            } else {
                boolean bl3 = "UInt16".equals(string) ? true : "Int32".equals(string);
                if (bl3) {
                    some = new Some((Object)IntegerType$.MODULE$);
                } else {
                    boolean bl4 = "UInt32".equals(string) ? true : ("Int64".equals(string) ? true : ("UInt64".equals(string) ? true : "IPv4".equals(string)));
                    if (bl4) {
                        some = new Some((Object)LongType$.MODULE$);
                    } else {
                        boolean bl5 = "Int128".equals(string) ? true : ("Int256".equals(string) ? true : "UInt256".equals(string));
                        if (bl5) {
                            some = None$.MODULE$;
                        } else if ("Float32".equals(string)) {
                            some = new Some((Object)FloatType$.MODULE$);
                        } else if ("Float64".equals(string)) {
                            some = new Some((Object)DoubleType$.MODULE$);
                        } else {
                            Option option3 = this.dateTypePattern().unapplySeq((CharSequence)string);
                            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0) {
                                some = new Some((Object)DateType$.MODULE$);
                            } else {
                                Option option4 = this.dateTimeTypePattern().unapplySeq((CharSequence)string);
                                if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(0) == 0) {
                                    some = new Some((Object)TimestampType$.MODULE$);
                                } else {
                                    Option option5 = this.decimalTypePattern().unapplySeq((CharSequence)string);
                                    if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(2) == 0) {
                                        String precision2 = (String)((LinearSeqOptimized)option5.get()).apply(0);
                                        String scale2 = (String)((LinearSeqOptimized)option5.get()).apply(1);
                                        some = new Some((Object)new DecimalType(new StringOps(Predef$.MODULE$.augmentString(precision2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(scale2)).toInt()));
                                    } else {
                                        Option option6 = this.decimalTypePattern2().unapplySeq((CharSequence)string);
                                        if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(2) == 0) {
                                            Some some2;
                                            String w = (String)((LinearSeqOptimized)option6.get()).apply(0);
                                            String scale3 = (String)((LinearSeqOptimized)option6.get()).apply(1);
                                            String string2 = w;
                                            if ("32".equals(string2)) {
                                                some2 = new Some((Object)new DecimalType(9, new StringOps(Predef$.MODULE$.augmentString(scale3)).toInt()));
                                            } else if ("64".equals(string2)) {
                                                some2 = new Some((Object)new DecimalType(18, new StringOps(Predef$.MODULE$.augmentString(scale3)).toInt()));
                                            } else if ("128".equals(string2)) {
                                                some2 = new Some((Object)new DecimalType(38, new StringOps(Predef$.MODULE$.augmentString(scale3)).toInt()));
                                            } else {
                                                if (!"256".equals(string2)) throw new MatchError((Object)string2);
                                                some2 = new Some((Object)new DecimalType(76, new StringOps(Predef$.MODULE$.augmentString(scale3)).toInt()));
                                            }
                                            some = some2;
                                        } else {
                                            some = None$.MODULE$;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Some dataType = some;
        return dataType.map((Function1)new Serializable(nullable2){
            public static final long serialVersionUID = 0L;
            private final boolean nullable$1;

            public final Tuple2<Object, AtomicType> apply(AtomicType x$3) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.nullable$1), (Object)x$3);
            }
            {
                this.nullable$1 = nullable$1;
            }
        });
    }

    public Tuple2<Object, String> unwrapNullable(String maybeNullableTypeName) {
        Tuple2 tuple2;
        String string = maybeNullableTypeName;
        Option option = this.nullableTypePattern().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String typeName = (String)((LinearSeqOptimized)option.get()).apply(0);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)typeName);
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)maybeNullableTypeName);
        }
        return tuple2;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        Object object;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("String", 12));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("String", -2));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("UInt8", 16));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Int8", -6));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Int16", 5));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Int32", 4));
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Int64", -5));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Float32", 6));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Float64", 8));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            object = new Some((Object)new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decimal(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())})), 3));
        } else {
            ArrayType arrayType;
            DataType et;
            object = DateType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("Date", 91)) : (TimestampType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("DateTime", 93)) : (dataType instanceof ArrayType && (et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType ? this.getJDBCType(et).orElse((Function0)new Serializable(et){
                public static final long serialVersionUID = 0L;
                private final DataType et$1;

                public final Option<JdbcType> apply() {
                    return JdbcUtils$.MODULE$.getCommonJDBCType(this.et$1);
                }
                {
                    this.et$1 = et$1;
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JdbcType apply(JdbcType jdbcType) {
                    return new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Array(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jdbcType.databaseTypeDefinition()})), 2003);
                }
            }) : None$.MODULE$));
        }
        return object;
    }

    public String quoteIdentifier(String colName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colName}));
    }

    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Object compileValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.escapeSql(string)}));
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder().append((Object)"'").append((Object)timestamp).append((Object)"'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder().append((Object)"'").append((Object)date).append((Object)"'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object value) {
                    return ClickHouseDialect$.MODULE$.compileValue(value);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString("[", ",", "]");
        } else {
            object = value;
        }
        return object;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ClickHouseDialect$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.arrayTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Array\\((.*)\\)$")).r();
        this.dateTypePattern = new StringOps(Predef$.MODULE$.augmentString("^[dD][aA][tT][eE]$")).r();
        this.dateTimeTypePattern = new StringOps(Predef$.MODULE$.augmentString("^[dD][aA][tT][eE][tT][iI][mM][eE](64)?(\\((.*)\\))?$")).r();
        this.decimalTypePattern = new StringOps(Predef$.MODULE$.augmentString("^[dD][eE][cC][iI][mM][aA][lL]\\((\\d+),\\s*(\\d+)\\)$")).r();
        this.decimalTypePattern2 = new StringOps(Predef$.MODULE$.augmentString("^[dD][eE][cC][iI][mM][aA][lL](32|64|128|256)\\((\\d+)\\)$")).r();
        this.enumTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Enum(8|16)$")).r();
        this.fixedStringTypePattern = new StringOps(Predef$.MODULE$.augmentString("^FixedString\\((\\d+)\\)$")).r();
        this.nullableTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Nullable\\((.*)\\)")).r();
    }
}

