/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data;

import com.github.housepower.jdbc.connect.PhysicalInfo;
import com.github.housepower.jdbc.data.BlockSettings;
import com.github.housepower.jdbc.data.ColumnFactory;
import com.github.housepower.jdbc.data.ColumnWriterBuffer;
import com.github.housepower.jdbc.data.DataTypeFactory;
import com.github.housepower.jdbc.data.IColumn;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class Block {
    private final IColumn[] columns;
    private final BlockSettings settings;
    private final Map<String, Integer> nameWithPosition;
    private final Object[] objects;
    private final int[] columnIndexAdds;
    private int rows;

    public static Block readFrom(BinaryDeserializer deserializer, PhysicalInfo.ServerInfo serverInfo) throws IOException, SQLException {
        BlockSettings info = BlockSettings.readFrom(deserializer);
        int columns = (int)deserializer.readVarInt();
        int rows = (int)deserializer.readVarInt();
        IColumn[] cols = new IColumn[columns];
        for (int i = 0; i < columns; ++i) {
            String name = deserializer.readStringBinary();
            String type = deserializer.readStringBinary();
            IDataType dataType = DataTypeFactory.get(type, serverInfo);
            Object[] arr = dataType.deserializeBinaryBulk(rows, deserializer);
            cols[i] = ColumnFactory.createColumn(name, dataType, arr);
        }
        return new Block(rows, cols, info);
    }

    public Block() {
        this(0, new IColumn[0]);
    }

    public Block(int rows, IColumn[] columns) {
        this(rows, columns, new BlockSettings(BlockSettings.Setting.values()));
    }

    public Block(int rows, IColumn[] columns, BlockSettings settings) {
        this.rows = rows;
        this.columns = columns;
        this.settings = settings;
        this.objects = new Object[columns.length];
        this.columnIndexAdds = new int[columns.length];
        this.nameWithPosition = new HashMap<String, Integer>();
        for (int i = 0; i < columns.length; ++i) {
            this.nameWithPosition.put(columns[i].name(), i + 1);
            this.columnIndexAdds[i] = i;
        }
    }

    public void appendRow() throws SQLException {
        int i = 0;
        try {
            for (i = 0; i < this.columns.length; ++i) {
                this.columns[i].write(this.objects[i]);
            }
            ++this.rows;
        }
        catch (IOException | ClassCastException e) {
            throw new SQLException("Exception processing value " + this.objects[i] + " for column: " + this.columns[i].name(), e);
        }
    }

    public void setObject(int i, Object object) throws SQLException {
        this.objects[this.columnIndexAdds[i]] = object;
    }

    public void setConstObject(int i, Object object) throws SQLException {
        this.objects[i] = object;
    }

    public void incrIndex(int i) {
        int j = i;
        while (j < this.columnIndexAdds.length) {
            int n = j++;
            this.columnIndexAdds[n] = this.columnIndexAdds[n] + 1;
        }
    }

    public void writeTo(BinarySerializer serializer) throws IOException, SQLException {
        this.settings.writeTo(serializer);
        serializer.writeVarInt(this.columns.length);
        serializer.writeVarInt(this.rows);
        for (IColumn column : this.columns) {
            column.flushToSerializer(serializer, true);
        }
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns.length;
    }

    public IColumn getByPosition(int column) throws SQLException {
        Validate.isTrue(column < this.columns.length, "Position " + column + " is out of bound in Block.getByPosition, max position = " + (this.columns.length - 1));
        return this.columns[column];
    }

    public int getPositionByName(String name) throws SQLException {
        Validate.isTrue(this.nameWithPosition.containsKey(name), "Column '" + name + "' does not exist");
        return this.nameWithPosition.get(name);
    }

    public Object getObject(int index) throws SQLException {
        Validate.isTrue(index < this.columns.length, "Position " + index + " is out of bound in Block.getByPosition, max position = " + (this.columns.length - 1));
        return this.objects[index];
    }

    public void initWriteBuffer() {
        for (IColumn column : this.columns) {
            column.setColumnWriterBuffer(new ColumnWriterBuffer());
        }
    }
}

