/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data;

import com.github.housepower.jdbc.ClickHouseStruct;
import com.github.housepower.jdbc.data.AbstractColumn;
import com.github.housepower.jdbc.data.ColumnFactory;
import com.github.housepower.jdbc.data.ColumnWriterBuffer;
import com.github.housepower.jdbc.data.IColumn;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.data.type.complex.DataTypeTuple;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class ColumnTuple
extends AbstractColumn {
    private final IColumn[] columndataArray;

    public ColumnTuple(String name, DataTypeTuple type, Object[] values) {
        super(name, type, values);
        IDataType[] types = type.getNestedTypes();
        this.columndataArray = new IColumn[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.columndataArray[i] = ColumnFactory.createColumn(null, types[i], null);
        }
    }

    @Override
    public void write(Object object) throws IOException, SQLException {
        ClickHouseStruct tuple = (ClickHouseStruct)object;
        for (int i = 0; i < this.columndataArray.length; ++i) {
            this.columndataArray[i].write(tuple.getAttributes()[i]);
        }
    }

    @Override
    public void flushToSerializer(BinarySerializer serializer, boolean now) throws SQLException, IOException {
        if (this.isExported()) {
            serializer.writeStringBinary(this.name);
            serializer.writeStringBinary(this.type.name());
        }
        for (IColumn data : this.columndataArray) {
            data.flushToSerializer(serializer, true);
        }
        if (now) {
            this.buffer.writeTo(serializer);
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
        for (IColumn data : this.columndataArray) {
            data.setColumnWriterBuffer(new ColumnWriterBuffer());
        }
    }

    @Override
    public void clear() {
    }
}

