/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data.type.complex;

import com.github.housepower.jdbc.connect.PhysicalInfo;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.misc.DateTimeHelper;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.StringView;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class DataTypeDateTime64
implements IDataType {
    public static final Timestamp DEFAULT_VALUE = new Timestamp(0L);
    public static final int NANOS_IN_SECOND = 1000000000;
    public static final int MILLIS_IN_SECOND = 1000;
    private final String name;
    private final ZoneId tz;

    public static DataTypeDateTime64 createDateTime64Type(SQLLexer lexer, PhysicalInfo.ServerInfo serverInfo) throws SQLException {
        if (lexer.isCharacter('(')) {
            Validate.isTrue(lexer.character() == '(');
            int precision = lexer.numberLiteral().intValue();
            if (lexer.isCharacter(',')) {
                Validate.isTrue(lexer.character() == ',');
                Validate.isTrue(lexer.isWhitespace());
                String dataTimeZone = lexer.stringLiteral();
                Validate.isTrue(lexer.character() == ')');
                return new DataTypeDateTime64("DateTime64(" + precision + ", '" + dataTimeZone + "')", serverInfo);
            }
            Validate.isTrue(lexer.character() == ')');
            return new DataTypeDateTime64("DateTime64(" + precision + ")", serverInfo);
        }
        return new DataTypeDateTime64("DateTime64", serverInfo);
    }

    public DataTypeDateTime64(String name, PhysicalInfo.ServerInfo serverInfo) {
        this.name = name;
        this.tz = DateTimeHelper.chooseTimeZone(serverInfo);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 93;
    }

    @Override
    public Object defaultValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public Class javaTypeClass() {
        return Timestamp.class;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 19;
    }

    @Override
    public Object deserializeTextQuoted(SQLLexer lexer) throws SQLException {
        StringView dataTypeName = lexer.bareWord();
        Validate.isTrue(dataTypeName.checkEquals("toDateTime64"));
        Validate.isTrue(lexer.character() == '(');
        Validate.isTrue(lexer.character() == '\'');
        int year = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == '-');
        int month = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == '-');
        int day = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.isWhitespace());
        int hours = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == ':');
        int minutes = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == ':');
        int seconds = lexer.intLiteral();
        Validate.isTrue(lexer.character() == '.');
        int nanos = lexer.intLiteral();
        Validate.isTrue(lexer.character() == '\'');
        Validate.isTrue(lexer.character() == ')');
        ZonedDateTime zdt = ZonedDateTime.of(year, month, day, hours, minutes, seconds, nanos, this.tz);
        return Timestamp.from(zdt.toInstant());
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws IOException {
        long value = deserializer.readLong();
        long epochSeconds = value / 1000000000L;
        int nanos = (int)(value % 1000000000L);
        Timestamp timestamp = new Timestamp(epochSeconds * 1000L);
        if (nanos != 0) {
            timestamp.setNanos(nanos);
        }
        return timestamp;
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws IOException {
        Timestamp timestamp = (Timestamp)data;
        long epochSeconds = timestamp.getTime() / 1000L;
        int nanos = timestamp.getNanos();
        long value = epochSeconds * 1000000000L + (long)nanos;
        serializer.writeLong(value);
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws IOException {
        Object[] data = new Timestamp[rows];
        for (int row = 0; row < rows; ++row) {
            data[row] = (Timestamp)this.deserializeBinary(deserializer);
        }
        return data;
    }
}

