/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.misc;

import com.github.housepower.jdbc.misc.StringView;
import com.github.housepower.jdbc.misc.Validate;
import java.sql.SQLException;

public class SQLLexer {
    private int pos;
    private final char[] data;

    public SQLLexer(int pos, String data) {
        this.pos = pos;
        this.data = data.toCharArray();
    }

    public char character() {
        return this.eof() ? (char)'\u0000' : this.data[this.pos++];
    }

    public int intLiteral() {
        this.skipAnyWhitespace();
        int start = this.pos;
        if (this.isCharacter('-') || this.isCharacter('+')) {
            ++this.pos;
        }
        while (this.pos < this.data.length && this.isNumericASCII(this.data[this.pos])) {
            ++this.pos;
        }
        return Integer.parseInt(new StringView(start, this.pos, this.data).toString());
    }

    public Number numberLiteral() {
        this.skipAnyWhitespace();
        int start = this.pos;
        boolean isHex = false;
        boolean isBinary = false;
        boolean isDouble = false;
        boolean hasExponent = false;
        boolean hasSigned = false;
        if (this.isCharacter('-') || this.isCharacter('+')) {
            hasSigned = true;
            ++this.pos;
        }
        if (this.pos + 2 < this.data.length && this.data[this.pos] == '0' && (this.data[this.pos + 1] == 'x' || this.data[this.pos + 1] == 'X' || this.data[this.pos + 1] == 'b' || this.data[this.pos + 1] == 'B')) {
            isHex = this.data[this.pos + 1] == 'x' || this.data[this.pos + 1] == 'X';
            isBinary = this.data[this.pos + 1] == 'b' || this.data[this.pos + 1] == 'B';
            this.pos += 2;
        }
        while (this.pos < this.data.length && !(isHex ? !this.isHexDigit(this.data[this.pos]) : !this.isNumericASCII(this.data[this.pos]))) {
            ++this.pos;
        }
        if (this.pos < this.data.length && this.data[this.pos] == '.') {
            isDouble = true;
            ++this.pos;
            while (this.pos < this.data.length && !(isHex ? !this.isHexDigit(this.data[this.pos]) : !this.isNumericASCII(this.data[this.pos]))) {
                ++this.pos;
            }
        }
        if (this.pos + 1 < this.data.length && (isHex ? this.data[this.pos] == 'p' || this.data[this.pos] == 'P' : this.data[this.pos] == 'e' || this.data[this.pos] == 'E')) {
            char ch;
            hasExponent = true;
            ++this.pos;
            if (this.pos + 1 < this.data.length && (this.data[this.pos] == '-' || this.data[this.pos] == '+')) {
                ++this.pos;
            }
            while (this.pos < this.data.length && this.isNumericASCII(ch = this.data[this.pos])) {
                ++this.pos;
            }
        }
        if (isBinary) {
            String signed = hasSigned ? this.data[start] + "" : "";
            int begin = start + (hasSigned ? 3 : 2);
            return Long.parseLong(signed + new String(this.data, begin, this.pos - begin), 2);
        }
        if (isDouble || hasExponent) {
            return Double.valueOf(new String(this.data, start, this.pos - start));
        }
        if (isHex) {
            String signed = hasSigned ? this.data[start] + "" : "";
            int begin = start + (hasSigned ? 3 : 2);
            return Long.parseLong(signed + new String(this.data, begin, this.pos - begin), 16);
        }
        return Long.parseLong(new String(this.data, start, this.pos - start));
    }

    public String stringLiteral() throws SQLException {
        return this.stringView().toString();
    }

    public StringView stringView() throws SQLException {
        this.skipAnyWhitespace();
        Validate.isTrue(this.isCharacter('\''));
        return this.stringLiteralWithQuoted('\'');
    }

    public boolean eof() {
        this.skipAnyWhitespace();
        return this.pos >= this.data.length;
    }

    public boolean isCharacter(char ch) {
        return !this.eof() && this.data[this.pos] == ch;
    }

    public StringView bareWord() throws SQLException {
        this.skipAnyWhitespace();
        if (this.isCharacter('`')) {
            return this.stringLiteralWithQuoted('`');
        }
        if (this.isCharacter('\"')) {
            return this.stringLiteralWithQuoted('\"');
        }
        if ('_' == this.data[this.pos] || this.data[this.pos] >= 'a' && this.data[this.pos] <= 'z' || this.data[this.pos] >= 'A' && this.data[this.pos] <= 'Z') {
            int start = this.pos++;
            while (this.pos < this.data.length && ('_' == this.data[this.pos] || this.data[this.pos] >= 'a' && this.data[this.pos] <= 'z' || this.data[this.pos] >= 'A' && this.data[this.pos] <= 'Z' || this.data[this.pos] >= '0' && this.data[this.pos] <= '9')) {
                ++this.pos;
            }
            return new StringView(start, this.pos, this.data);
        }
        throw new SQLException("Expect Bare Token.");
    }

    public boolean isWhitespace() {
        return this.data[this.pos++] == ' ';
    }

    private boolean isNumericASCII(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isHexDigit(char c) {
        return this.isNumericASCII(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private void skipAnyWhitespace() {
        while (this.pos < this.data.length) {
            if (this.data[this.pos] != ' ' && this.data[this.pos] != '\t' && this.data[this.pos] != '\n' && this.data[this.pos] != '\r' && this.data[this.pos] != '\f') {
                return;
            }
            ++this.pos;
        }
    }

    private StringView stringLiteralWithQuoted(char quoted) throws SQLException {
        int start = this.pos;
        Validate.isTrue(this.data[this.pos] == quoted);
        ++this.pos;
        while (this.pos < this.data.length) {
            if (this.data[this.pos] == '\\') {
                ++this.pos;
            } else if (this.data[this.pos] == quoted) {
                return new StringView(start + 1, this.pos++, this.data);
            }
            ++this.pos;
        }
        throw new SQLException("The String Literal is no Closed.");
    }
}

