/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.misc;

import java.nio.CharBuffer;

public class StringView {
    private final int start;
    private final int end;
    private final char[] values;

    public StringView(int start, int end, char[] values) {
        this.start = start;
        this.end = end;
        this.values = values;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public char[] values() {
        return this.values;
    }

    public boolean checkEquals(String expectString) {
        if (expectString == null || expectString.length() != this.end - this.start) {
            return false;
        }
        for (int i = 0; i < expectString.length(); ++i) {
            if (expectString.charAt(i) == this.values[this.start + i]) continue;
            return false;
        }
        return true;
    }

    public CharBuffer toCharBuffer() {
        return CharBuffer.wrap(this.values, this.start, this.end - this.start);
    }

    public String toString() {
        return new String(this.values, this.start, this.end - this.start);
    }
}

