/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.protocol;

import com.github.housepower.jdbc.protocol.ProtocolType;
import com.github.housepower.jdbc.protocol.RequestOrResponse;
import com.github.housepower.jdbc.serializer.BinaryDeserializer;
import com.github.housepower.jdbc.serializer.BinarySerializer;
import java.io.IOException;
import java.time.ZoneId;

public class HelloResponse
extends RequestOrResponse {
    private final long reversion;
    private final long majorVersion;
    private final long minorVersion;
    private final String serverName;
    private final String serverTimeZone;
    private final String serverDisplayName;

    public HelloResponse(String serverName, long majorVersion, long minorVersion, long reversion, String serverTimeZone, String serverDisplayName) {
        super(ProtocolType.RESPONSE_HELLO);
        this.reversion = reversion;
        this.serverName = serverName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.serverTimeZone = serverTimeZone;
        this.serverDisplayName = serverDisplayName;
    }

    public long reversion() {
        return this.reversion;
    }

    public long majorVersion() {
        return this.majorVersion;
    }

    public long minorVersion() {
        return this.minorVersion;
    }

    public String serverName() {
        return this.serverName;
    }

    public String serverTimeZone() {
        return this.serverTimeZone;
    }

    public String serverDisplayName() {
        return this.serverDisplayName;
    }

    @Override
    public void writeImpl(BinarySerializer serializer) {
        throw new UnsupportedOperationException("HelloResponse Cannot write to Server.");
    }

    public static HelloResponse readFrom(BinaryDeserializer deserializer) throws IOException {
        String name = deserializer.readStringBinary();
        long majorVersion = deserializer.readVarInt();
        long minorVersion = deserializer.readVarInt();
        long serverReversion = deserializer.readVarInt();
        String serverTimeZone = HelloResponse.getTimeZone(deserializer, serverReversion);
        String serverDisplayName = HelloResponse.getDisplayName(deserializer, serverReversion);
        return new HelloResponse(name, majorVersion, minorVersion, serverReversion, serverTimeZone, serverDisplayName);
    }

    private static String getTimeZone(BinaryDeserializer deserializer, long serverReversion) throws IOException {
        return serverReversion >= 54058L ? deserializer.readStringBinary() : ZoneId.systemDefault().getId();
    }

    private static String getDisplayName(BinaryDeserializer deserializer, long serverReversion) throws IOException {
        return serverReversion >= 54372L ? deserializer.readStringBinary() : "localhost";
    }
}

