/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.settings;

import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.settings.SettingKey;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClickHouseConfig {
    public static final Pattern DB_PATH_PATTERN = Pattern.compile("/([a-zA-Z0-9_]+)");
    public static final Pattern HOST_PORT_PATH_PATTERN = Pattern.compile("//(?<host>[^/:\\s]+)(:(?<port>\\d+))?");
    private final int port;
    private final String address;
    private final String database;
    private final String username;
    private final String password;
    private int soTimeout;
    private final int connectTimeout;
    private final Map<SettingKey, Object> settings;

    private ClickHouseConfig(int port, String address, String database, String username, String password, int soTimeout, int connectTimeout, Map<SettingKey, Object> settings) {
        this.port = port;
        this.address = address;
        this.database = database;
        this.username = username;
        this.password = password;
        this.soTimeout = soTimeout;
        this.connectTimeout = connectTimeout;
        this.settings = settings;
    }

    public ClickHouseConfig(String url, Properties properties) throws SQLException {
        this.settings = this.parseJDBCUrl(url);
        this.settings.putAll(this.parseJDBCProperties(properties));
        Object obj = this.settings.remove((Object)SettingKey.port);
        this.port = obj == null ? 9000 : ((Integer)obj == -1 ? 9000 : (Integer)obj);
        obj = this.settings.remove((Object)SettingKey.address);
        this.address = obj == null ? "127.0.0.1" : String.valueOf(obj);
        obj = this.settings.remove((Object)SettingKey.password);
        this.password = obj == null ? "" : String.valueOf(obj);
        obj = this.settings.remove((Object)SettingKey.user);
        this.username = obj == null ? "default" : String.valueOf(obj);
        obj = this.settings.remove((Object)SettingKey.database);
        this.database = obj == null ? "default" : String.valueOf(obj);
        obj = this.settings.remove((Object)SettingKey.query_timeout);
        this.soTimeout = obj == null ? 0 : (Integer)obj * 1000;
        obj = this.settings.remove((Object)SettingKey.connect_timeout);
        this.connectTimeout = obj == null ? 0 : (Integer)obj * 1000;
    }

    public int port() {
        return this.port;
    }

    public String address() {
        return this.address;
    }

    public String database() {
        return this.database;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public int queryTimeout() {
        return this.soTimeout;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public Map<SettingKey, Object> settings() {
        return this.settings;
    }

    public Map<SettingKey, Object> parseJDBCProperties(Properties properties) {
        HashMap<SettingKey, Object> settings = new HashMap<SettingKey, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            for (SettingKey settingKey : SettingKey.values()) {
                String name = String.valueOf(entry.getKey());
                if (!settingKey.name().equalsIgnoreCase(name)) continue;
                settings.put(settingKey, settingKey.type().deserializeURL(String.valueOf(entry.getValue())));
            }
        }
        return settings;
    }

    private Map<SettingKey, Object> parseJDBCUrl(String jdbcUrl) throws SQLException {
        try {
            URI uri = new URI(jdbcUrl.substring(5));
            String host = this.parseHost(jdbcUrl);
            Integer port = this.parsePort(jdbcUrl);
            String database = this.parseDatabase(jdbcUrl);
            HashMap<SettingKey, Object> settings = new HashMap<SettingKey, Object>();
            settings.put(SettingKey.address, host);
            settings.put(SettingKey.port, port);
            settings.put(SettingKey.database, database);
            settings.putAll(this.extractQueryParameters(uri.getQuery()));
            return settings;
        }
        catch (URISyntaxException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    private String parseDatabase(String jdbcUrl) throws URISyntaxException {
        URI uri = new URI(jdbcUrl.substring(5));
        String database = uri.getPath();
        if (database != null && !database.isEmpty()) {
            Matcher m = DB_PATH_PATTERN.matcher(database);
            if (m.matches()) {
                database = m.group(1);
            } else {
                throw new URISyntaxException("wrong database name path: '" + database + "'", jdbcUrl);
            }
        }
        if (database != null && database.isEmpty()) {
            database = "default";
        }
        return database;
    }

    private String parseHost(String jdbcUrl) throws URISyntaxException {
        String uriStr = jdbcUrl.substring(5);
        URI uri = new URI(uriStr);
        String host = uri.getHost();
        if (host == null || host.isEmpty()) {
            Matcher m = HOST_PORT_PATH_PATTERN.matcher(uriStr);
            if (m.find()) {
                host = m.group("host");
            } else {
                throw new URISyntaxException("No valid host was found", jdbcUrl);
            }
        }
        return host;
    }

    private int parsePort(String jdbcUrl) throws URISyntaxException {
        Matcher m;
        String uriStr = jdbcUrl.substring(5);
        URI uri = new URI(uriStr);
        int port = uri.getPort();
        if (port <= -1 && (m = HOST_PORT_PATH_PATTERN.matcher(uriStr)).find() && m.group("port") != null) {
            port = Integer.parseInt(m.group("port"));
        }
        return port;
    }

    private Map<SettingKey, Object> extractQueryParameters(String queryParameters) throws SQLException {
        HashMap<SettingKey, Object> parameters = new HashMap<SettingKey, Object>();
        StringTokenizer tokenizer = new StringTokenizer(queryParameters == null ? "" : queryParameters, "&");
        while (tokenizer.hasMoreTokens()) {
            String[] queryParameter = tokenizer.nextToken().split("=", 2);
            Validate.isTrue(queryParameter.length == 2, "ClickHouse JDBC URL Parameter '" + queryParameters + "' Error, Expected '='.");
            for (SettingKey settingKey : SettingKey.values()) {
                if (!settingKey.name().equalsIgnoreCase(queryParameter[0])) continue;
                parameters.put(settingKey, settingKey.type().deserializeURL(queryParameter[1]));
            }
        }
        return parameters;
    }

    public void setQueryTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    public ClickHouseConfig copy() {
        return new ClickHouseConfig(this.port, this.address, this.database, this.username, this.password, this.soTimeout, this.connectTimeout, new HashMap<SettingKey, Object>(this.settings));
    }
}

