/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.protocol;

import com.github.housepower.jdbc.protocol.DataRequest;
import com.github.housepower.jdbc.protocol.Request;
import com.github.housepower.jdbc.serde.BinarySerializer;
import com.github.housepower.jdbc.serde.SettingType;
import com.github.housepower.jdbc.settings.SettingKey;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class QueryRequest
implements Request {
    public static final int STAGE_FETCH_COLUMNS = 0;
    public static final int STAGE_WITH_MERGEABLE_STATE = 1;
    public static final int STAGE_COMPLETE = 2;
    public static final int STAGE_WITH_MERGEABLE_STATE_AFTER_AGGREGATION = 3;
    private final int stage;
    private final String queryId;
    private final String queryString;
    private final boolean compression;
    private final ClientContext clientContext;
    private final Map<SettingKey, Object> settings;

    public QueryRequest(String queryId, ClientContext clientContext, int stage, boolean compression, String queryString) {
        this(queryId, clientContext, stage, compression, queryString, new HashMap<SettingKey, Object>());
    }

    public QueryRequest(String queryId, ClientContext clientContext, int stage, boolean compression, String queryString, Map<SettingKey, Object> settings) {
        this.stage = stage;
        this.queryId = queryId;
        this.settings = settings;
        this.clientContext = clientContext;
        this.compression = compression;
        this.queryString = queryString;
    }

    @Override
    public Request.ProtoType type() {
        return Request.ProtoType.REQUEST_QUERY;
    }

    @Override
    public void writeImpl(BinarySerializer serializer) throws IOException, SQLException {
        serializer.writeUTF8StringBinary(this.queryId);
        this.clientContext.writeTo(serializer);
        for (Map.Entry<SettingKey, Object> entry : this.settings.entrySet()) {
            serializer.writeUTF8StringBinary(entry.getKey().name());
            SettingType<?> type = entry.getKey().type();
            type.serializeSetting(serializer, entry.getValue());
        }
        serializer.writeUTF8StringBinary("");
        serializer.writeVarInt(this.stage);
        serializer.writeBoolean(this.compression);
        serializer.writeUTF8StringBinary(this.queryString);
        DataRequest.EMPTY.writeTo(serializer);
    }

    public static class ClientContext {
        public static final int TCP_KINE = 1;
        public static final byte NO_QUERY = 0;
        public static final byte INITIAL_QUERY = 1;
        public static final byte SECONDARY_QUERY = 2;
        private final String clientName;
        private final String clientHostname;
        private final String initialAddress;

        public ClientContext(String initialAddress, String clientHostname, String clientName) {
            this.clientName = clientName;
            this.clientHostname = clientHostname;
            this.initialAddress = initialAddress;
        }

        public void writeTo(BinarySerializer serializer) throws IOException {
            serializer.writeVarInt(1L);
            serializer.writeUTF8StringBinary("");
            serializer.writeUTF8StringBinary("");
            serializer.writeUTF8StringBinary(this.initialAddress);
            serializer.writeVarInt(1L);
            serializer.writeUTF8StringBinary("");
            serializer.writeUTF8StringBinary(this.clientHostname);
            serializer.writeUTF8StringBinary(this.clientName);
            serializer.writeVarInt(1L);
            serializer.writeVarInt(1L);
            serializer.writeVarInt(54380L);
            serializer.writeUTF8StringBinary("");
        }
    }
}

