/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data.type.complex;

import com.github.housepower.client.NativeContext;
import com.github.housepower.data.IDataType;
import com.github.housepower.data.type.complex.DataTypeCreator;
import com.github.housepower.misc.DateTimeUtil;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.misc.StringView;
import com.github.housepower.misc.Validate;
import com.github.housepower.serde.BinaryDeserializer;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class DataTypeDateTime64
implements IDataType<ZonedDateTime, Timestamp> {
    public static DataTypeCreator<ZonedDateTime, Timestamp> creator = (lexer, serverContext) -> {
        if (lexer.isCharacter('(')) {
            Validate.isTrue(lexer.character() == '(');
            int scale = lexer.numberLiteral().intValue();
            Validate.isTrue(scale >= 0 && scale <= 9, "scale=" + scale + " out of range [" + 0 + "," + 9 + "]");
            if (lexer.isCharacter(',')) {
                Validate.isTrue(lexer.character() == ',');
                Validate.isTrue(lexer.isWhitespace());
                String dataTimeZone = lexer.stringLiteral();
                Validate.isTrue(lexer.character() == ')');
                return new DataTypeDateTime64("DateTime64(" + scale + ", '" + dataTimeZone + "')", scale, serverContext);
            }
            Validate.isTrue(lexer.character() == ')');
            return new DataTypeDateTime64("DateTime64(" + scale + ")", scale, serverContext);
        }
        return new DataTypeDateTime64("DateTime64", 3, serverContext);
    };
    private static final LocalDateTime EPOCH_LOCAL_DT = LocalDateTime.of(1970, 1, 1, 0, 0);
    public static final int NANOS_IN_SECOND = 1000000000;
    public static final int MILLIS_IN_SECOND = 1000;
    public static final int[] POW_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final int MIN_SCALE = 0;
    public static final int MAX_SCALA = 9;
    public static final int DEFAULT_SCALE = 3;
    private final String name;
    private final int scale;
    private final ZoneId tz;
    private final ZonedDateTime defaultValue;

    public DataTypeDateTime64(String name, int scala, NativeContext.ServerContext serverContext) {
        this.name = name;
        this.scale = scala;
        this.tz = DateTimeUtil.chooseTimeZone(serverContext);
        this.defaultValue = EPOCH_LOCAL_DT.atZone(this.tz);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 93;
    }

    @Override
    public ZonedDateTime defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class<ZonedDateTime> javaType() {
        return ZonedDateTime.class;
    }

    @Override
    public Class<Timestamp> jdbcJavaType() {
        return Timestamp.class;
    }

    @Override
    public int getPrecision() {
        return 20;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public ZonedDateTime deserializeText(SQLLexer lexer) throws SQLException {
        StringView dataTypeName = lexer.bareWord();
        Validate.isTrue(dataTypeName.checkEquals("toDateTime64"));
        Validate.isTrue(lexer.character() == '(');
        Validate.isTrue(lexer.character() == '\'');
        int year = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == '-');
        int month = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == '-');
        int day = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.isWhitespace());
        int hours = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == ':');
        int minutes = lexer.numberLiteral().intValue();
        Validate.isTrue(lexer.character() == ':');
        BigDecimal _seconds = BigDecimal.valueOf(lexer.numberLiteral().doubleValue()).setScale(this.scale, 4);
        int second = _seconds.intValue();
        int nanos = _seconds.subtract(BigDecimal.valueOf(second)).movePointRight(9).intValue();
        Validate.isTrue(lexer.character() == '\'');
        Validate.isTrue(lexer.character() == ')');
        return ZonedDateTime.of(year, month, day, hours, minutes, second, nanos, this.tz);
    }

    @Override
    public void serializeBinary(ZonedDateTime data, BinarySerializer serializer) throws IOException {
        long epochSeconds = DateTimeUtil.toEpochSecond(data);
        int nanos = data.getNano();
        long value = (epochSeconds * 1000000000L + (long)nanos) / (long)POW_10[9 - this.scale];
        serializer.writeLong(value);
    }

    @Override
    public ZonedDateTime deserializeBinary(BinaryDeserializer deserializer) throws IOException {
        long value = deserializer.readLong() * (long)POW_10[9 - this.scale];
        long epochSeconds = value / 1000000000L;
        int nanos = (int)(value % 1000000000L);
        return DateTimeUtil.toZonedDateTime(epochSeconds, nanos, this.tz);
    }
}

