/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.misc;

public interface BytesHelper {
    default public byte[] getBytes(int i) {
        byte[] memory = new byte[4];
        this.setInt(memory, 0, i);
        return memory;
    }

    default public byte[] getBytesLE(int i) {
        byte[] memory = new byte[4];
        this.setIntLE(memory, 0, i);
        return memory;
    }

    default public byte[] getBytes(long l) {
        byte[] memory = new byte[8];
        this.setLong(memory, 0, l);
        return memory;
    }

    default public byte[] getBytesLE(long l) {
        byte[] memory = new byte[8];
        this.setLongLE(memory, 0, l);
        return memory;
    }

    default public byte[] getBytes(long[] longArray) {
        byte[] memory = new byte[8 * longArray.length];
        for (int index = 0; index < longArray.length; ++index) {
            long l = longArray[index];
            this.setLong(memory, index * 8, l);
        }
        return memory;
    }

    default public byte getByte(byte[] memory, int index) {
        return memory[index];
    }

    default public short getShort(byte[] memory, int index) {
        return (short)(memory[index] << 8 | memory[index + 1] & 0xFF);
    }

    default public short getShortLE(byte[] memory, int index) {
        return (short)(memory[index] & 0xFF | memory[index + 1] << 8);
    }

    default public int getUnsignedMedium(byte[] memory, int index) {
        return (memory[index] & 0xFF) << 16 | (memory[index + 1] & 0xFF) << 8 | memory[index + 2] & 0xFF;
    }

    default public int getUnsignedMediumLE(byte[] memory, int index) {
        return memory[index] & 0xFF | (memory[index + 1] & 0xFF) << 8 | (memory[index + 2] & 0xFF) << 16;
    }

    default public int getInt(byte[] memory, int index) {
        return (memory[index] & 0xFF) << 24 | (memory[index + 1] & 0xFF) << 16 | (memory[index + 2] & 0xFF) << 8 | memory[index + 3] & 0xFF;
    }

    default public int getIntLE(byte[] memory, int index) {
        return memory[index] & 0xFF | (memory[index + 1] & 0xFF) << 8 | (memory[index + 2] & 0xFF) << 16 | (memory[index + 3] & 0xFF) << 24;
    }

    default public long getLong(byte[] memory, int index) {
        return ((long)memory[index] & 0xFFL) << 56 | ((long)memory[index + 1] & 0xFFL) << 48 | ((long)memory[index + 2] & 0xFFL) << 40 | ((long)memory[index + 3] & 0xFFL) << 32 | ((long)memory[index + 4] & 0xFFL) << 24 | ((long)memory[index + 5] & 0xFFL) << 16 | ((long)memory[index + 6] & 0xFFL) << 8 | (long)memory[index + 7] & 0xFFL;
    }

    default public long getLongLE(byte[] memory, int index) {
        return (long)memory[index] & 0xFFL | ((long)memory[index + 1] & 0xFFL) << 8 | ((long)memory[index + 2] & 0xFFL) << 16 | ((long)memory[index + 3] & 0xFFL) << 24 | ((long)memory[index + 4] & 0xFFL) << 32 | ((long)memory[index + 5] & 0xFFL) << 40 | ((long)memory[index + 6] & 0xFFL) << 48 | ((long)memory[index + 7] & 0xFFL) << 56;
    }

    default public void setByte(byte[] memory, int index, int value) {
        memory[index] = (byte)value;
    }

    default public void setShort(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 8);
        memory[index + 1] = (byte)value;
    }

    default public void setShortLE(byte[] memory, int index, int value) {
        memory[index] = (byte)value;
        memory[index + 1] = (byte)(value >>> 8);
    }

    default public void setMedium(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 16);
        memory[index + 1] = (byte)(value >>> 8);
        memory[index + 2] = (byte)value;
    }

    default public void setMediumLE(byte[] memory, int index, int value) {
        memory[index] = (byte)value;
        memory[index + 1] = (byte)(value >>> 8);
        memory[index + 2] = (byte)(value >>> 16);
    }

    default public void setInt(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 24);
        memory[index + 1] = (byte)(value >>> 16);
        memory[index + 2] = (byte)(value >>> 8);
        memory[index + 3] = (byte)value;
    }

    default public void setIntLE(byte[] memory, int index, int value) {
        memory[index] = (byte)value;
        memory[index + 1] = (byte)(value >>> 8);
        memory[index + 2] = (byte)(value >>> 16);
        memory[index + 3] = (byte)(value >>> 24);
    }

    default public void setLong(byte[] memory, int index, long value) {
        memory[index] = (byte)(value >>> 56);
        memory[index + 1] = (byte)(value >>> 48);
        memory[index + 2] = (byte)(value >>> 40);
        memory[index + 3] = (byte)(value >>> 32);
        memory[index + 4] = (byte)(value >>> 24);
        memory[index + 5] = (byte)(value >>> 16);
        memory[index + 6] = (byte)(value >>> 8);
        memory[index + 7] = (byte)value;
    }

    default public void setLongLE(byte[] memory, int index, long value) {
        memory[index] = (byte)value;
        memory[index + 1] = (byte)(value >>> 8);
        memory[index + 2] = (byte)(value >>> 16);
        memory[index + 3] = (byte)(value >>> 24);
        memory[index + 4] = (byte)(value >>> 32);
        memory[index + 5] = (byte)(value >>> 40);
        memory[index + 6] = (byte)(value >>> 48);
        memory[index + 7] = (byte)(value >>> 56);
    }
}

