/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.misc;

import com.github.housepower.misc.StringView;
import com.github.housepower.misc.Validate;
import java.sql.SQLException;

public class SQLLexer {
    private int pos;
    private final String data;

    public SQLLexer(int pos, String data) {
        this.pos = pos;
        this.data = data;
    }

    public char character() {
        return this.eof() ? (char)'\u0000' : this.data.charAt(this.pos++);
    }

    public int intLiteral() {
        this.skipAnyWhitespace();
        int start = this.pos;
        if (this.isCharacter('-') || this.isCharacter('+')) {
            ++this.pos;
        }
        while (this.pos < this.data.length() && this.isNumericASCII(this.data.charAt(this.pos))) {
            ++this.pos;
        }
        return Integer.parseInt(new StringView(this.data, start, this.pos).toString());
    }

    public Number numberLiteral() {
        this.skipAnyWhitespace();
        int start = this.pos;
        boolean isHex = false;
        boolean isBinary = false;
        boolean isDouble = false;
        boolean hasExponent = false;
        boolean hasSigned = false;
        if (this.isCharacter('-') || this.isCharacter('+')) {
            hasSigned = true;
            ++this.pos;
        }
        if (this.pos + 2 < this.data.length() && this.data.charAt(this.pos) == '0' && (this.data.charAt(this.pos + 1) == 'x' || this.data.charAt(this.pos + 1) == 'X' || this.data.charAt(this.pos + 1) == 'b' || this.data.charAt(this.pos + 1) == 'B')) {
            isHex = this.data.charAt(this.pos + 1) == 'x' || this.data.charAt(this.pos + 1) == 'X';
            isBinary = this.data.charAt(this.pos + 1) == 'b' || this.data.charAt(this.pos + 1) == 'B';
            this.pos += 2;
        }
        while (this.pos < this.data.length() && !(isHex ? !this.isHexDigit(this.data.charAt(this.pos)) : !this.isNumericASCII(this.data.charAt(this.pos)))) {
            ++this.pos;
        }
        if (this.pos < this.data.length() && this.data.charAt(this.pos) == '.') {
            isDouble = true;
            ++this.pos;
            while (this.pos < this.data.length() && !(isHex ? !this.isHexDigit(this.data.charAt(this.pos)) : !this.isNumericASCII(this.data.charAt(this.pos)))) {
                ++this.pos;
            }
        }
        if (this.pos + 1 < this.data.length() && (isHex ? this.data.charAt(this.pos) == 'p' || this.data.charAt(this.pos) == 'P' : this.data.charAt(this.pos) == 'e' || this.data.charAt(this.pos) == 'E')) {
            char ch;
            hasExponent = true;
            ++this.pos;
            if (this.pos + 1 < this.data.length() && (this.data.charAt(this.pos) == '-' || this.data.charAt(this.pos) == '+')) {
                ++this.pos;
            }
            while (this.pos < this.data.length() && this.isNumericASCII(ch = this.data.charAt(this.pos))) {
                ++this.pos;
            }
        }
        if (isBinary) {
            String signed = hasSigned ? this.data.charAt(start) + "" : "";
            int begin = start + (hasSigned ? 3 : 2);
            return Long.parseLong(signed + new StringView(this.data, begin, this.pos).toString(), 2);
        }
        if (isDouble || hasExponent) {
            return Double.valueOf(new StringView(this.data, start, this.pos).toString());
        }
        if (isHex) {
            String signed = hasSigned ? this.data.charAt(start) + "" : "";
            int begin = start + (hasSigned ? 3 : 2);
            return Long.parseLong(signed + new StringView(this.data, begin, this.pos), 16);
        }
        return Long.parseLong(new StringView(this.data, start, this.pos).toString());
    }

    public String stringLiteral() throws SQLException {
        return this.stringView().toString();
    }

    public StringView stringView() throws SQLException {
        this.skipAnyWhitespace();
        Validate.isTrue(this.isCharacter('\''));
        return this.stringLiteralWithQuoted('\'');
    }

    public boolean eof() {
        this.skipAnyWhitespace();
        return this.pos >= this.data.length();
    }

    public boolean isCharacter(char ch) {
        return !this.eof() && this.data.charAt(this.pos) == ch;
    }

    public StringView bareWord() throws SQLException {
        this.skipAnyWhitespace();
        if (this.isCharacter('`')) {
            return this.stringLiteralWithQuoted('`');
        }
        if (this.isCharacter('\"')) {
            return this.stringLiteralWithQuoted('\"');
        }
        if (this.data.charAt(this.pos) == '_' || this.data.charAt(this.pos) >= 'a' && this.data.charAt(this.pos) <= 'z' || this.data.charAt(this.pos) >= 'A' && this.data.charAt(this.pos) <= 'Z') {
            int start = this.pos++;
            while (this.pos < this.data.length() && ('_' == this.data.charAt(this.pos) || this.data.charAt(this.pos) >= 'a' && this.data.charAt(this.pos) <= 'z' || this.data.charAt(this.pos) >= 'A' && this.data.charAt(this.pos) <= 'Z' || this.data.charAt(this.pos) >= '0' && this.data.charAt(this.pos) <= '9')) {
                ++this.pos;
            }
            return new StringView(this.data, start, this.pos);
        }
        throw new SQLException("Expect Bare Token.");
    }

    public boolean isWhitespace() {
        return this.data.charAt(this.pos++) == ' ';
    }

    private boolean isNumericASCII(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isHexDigit(char c) {
        return this.isNumericASCII(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private void skipAnyWhitespace() {
        while (this.pos < this.data.length()) {
            if (this.data.charAt(this.pos) != ' ' && this.data.charAt(this.pos) != '\t' && this.data.charAt(this.pos) != '\n' && this.data.charAt(this.pos) != '\r' && this.data.charAt(this.pos) != '\f') {
                return;
            }
            ++this.pos;
        }
    }

    private StringView stringLiteralWithQuoted(char quoted) throws SQLException {
        int start = this.pos;
        Validate.isTrue(this.data.charAt(this.pos) == quoted);
        ++this.pos;
        while (this.pos < this.data.length()) {
            if (this.data.charAt(this.pos) == '\\') {
                ++this.pos;
            } else if (this.data.charAt(this.pos) == quoted) {
                return new StringView(this.data, start + 1, this.pos++);
            }
            ++this.pos;
        }
        throw new SQLException("The String Literal is no Closed.");
    }
}

